<?php
// index.php
require_once 'includes/config.php';
require_once 'includes/functions.php';

// گرفتن صفحه از URL، پیش‌فرض home
$page = isset($_GET['page']) ? $_GET['page'] : 'home';

// لیست صفحات مجاز برای امنیت
$allowed_pages = ['home', 'check', 'dashboard', 'login', 'news', 'centers'];

if (!in_array($page, $allowed_pages)) {
    $page = 'home';
}

include 'includes/header.php';

// لود کردن محتوای صفحه
if (file_exists("pages/$page.php")) {
    include "pages/$page.php";
} else {
    echo "<div class='text-center py-20'>صفحه مورد نظر یافت نشد.</div>";
}

include 'includes/footer.php';
?>