<?php
// includes/functions.php

function render_icon($name, $class = "w-5 h-5") {
    // آیکون‌های ساده SVG برای عدم وابستگی به کتابخانه خارجی
    $icons = [
        'check' => '<path stroke-linecap="round" stroke-linejoin="round" d="M4.5 12.75l6 6 9-13.5" />',
        'user' => '<path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />',
        'menu' => '<path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />',
        'shield' => '<path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12c0 1.268-.63 2.39-1.593 3.068a3.745 3.745 0 01-1.043 3.296 3.745 3.745 0 01-3.296 1.043A3.745 3.745 0 0112 21c-1.268 0-2.39-.63-3.068-1.593a3.746 3.746 0 01-3.296-1.043 3.745 3.745 0 01-1.043-3.296A3.745 3.745 0 013 12c0-1.268.63-2.39 1.593-3.068a3.745 3.745 0 011.043-3.296 3.746 3.746 0 013.296-1.043A3.746 3.746 0 0112 3c1.268 0 2.39.63 3.068 1.593a3.746 3.746 0 013.296 1.043 3.746 3.746 0 011.043 3.296A3.745 3.745 0 0121 12z" />',
        'home' => '<path stroke-linecap="round" stroke-linejoin="round" d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />',
        'document' => '<path stroke-linecap="round" stroke-linejoin="round" d="M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z" />'
    ];
    $path = $icons[$name] ?? '';
    return "<svg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 24 24' stroke-width='1.5' stroke='currentColor' class='$class'>$path</svg>";
}

function alert_box($type, $title, $text) {
    $colors = [
        'warning' => 'bg-orange-50 border-orange-200 text-orange-900',
        'info' => 'bg-blue-50 border-blue-200 text-blue-900',
        'success' => 'bg-green-50 border-green-200 text-green-900',
        'error' => 'bg-red-50 border-red-200 text-red-900',
    ];
    $colorClass = $colors[$type] ?? $colors['info'];
    
    echo "
    <div class='p-4 rounded-lg border flex gap-3 mb-4 $colorClass'>
        <div class='mt-0.5'>" . render_icon('shield') . "</div>
        <div>
            <h4 class='font-bold text-sm mb-1'>$title</h4>
            <div class='text-sm opacity-90 leading-relaxed'>$text</div>
        </div>
    </div>";
}
// تابع اعتبارسنجی واقعی کد ملی ایران
function isValidNationalCode($code) {
    if (!preg_match('/^[0-9]{10}$/', $code)) return false;
    
    for ($i = 0; $i < 10; $i++)
        if (preg_match('/^' . $i . '{10}$/', $code)) return false;
        
    for ($i = 0, $sum = 0; $i < 9; $i++)
        $sum += ((10 - $i) * intval(substr($code, $i, 1)));
        
    $ret = $sum % 11;
    $parity = intval(substr($code, 9, 1));
    
    if (($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity))
        return true;
        
    return false;
}

// تابع اعتبارسنجی شماره موبایل ایران
function isValidMobile($mobile) {
    // باید با 09 شروع شود و 11 رقم باشد
    return preg_match('/^09[0-9]{9}$/', $mobile);
}
?>