<?php
// includes/config.php
session_start();

// تنظیم منطقه زمانی
date_default_timezone_set('Asia/Tehran');

// داده‌های ماک (شبیه‌سازی دیتابیس)
if (!isset($_SESSION['user'])) {
    // کاربر پیش‌فرض (لاگین نشده)
    $_SESSION['user'] = null;
}

// اگر دیتای استعلام‌ها وجود ندارد، ایجاد کن
if (!isset($_SESSION['inquiries'])) {
    $_SESSION['inquiries'] = [
        [
            'id' => 'ST-1402-8877',
            'date' => '1403/08/20',
            'amount' => 5000,
            'status' => 'ready', // ready, pending, error
            'gold_amount' => '2.5 گرم',
            'desc' => 'تخصیص مرحله اول'
        ]
    ];
}

// تابع تبدیل اعداد به فارسی
function fa_number($number) {
    $en = array("0","1","2","3","4","5","6","7","8","9");
    $fa = array("۰","۱","۲","۳","۴","۵","۶","۷","۸","۹");
    return str_replace($en, $fa, (string)$number);
}
?>