


<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بازی جذاب ایرانی - دانلود مستقیم</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;700;900&display=swap');
        
        :root {
            --bg-color: #120c18;
            --primary-color: #9f42ff;
            --secondary-color: #ff3b8d;
            --text-color: #f0e8ff;
            --card-bg: rgba(25, 18, 38, 0.7);
            --border-radius: 20px;
            --font-family: 'Vazirmatn', sans-serif;
            --glow-size: 150px;
        }

        *, *::before, *::after {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: var(--font-family);
            background-color: var(--bg-color);
            color: var(--text-color);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
        }

        .aurora-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -1;
        }

        .aurora {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.5;
            animation: move-aurora 20s infinite alternate;
        }

        .aurora-1 {
            width: var(--glow-size);
            height: var(--glow-size);
            background: radial-gradient(circle, var(--primary-color), transparent 60%);
            top: 10%;
            left: 20%;
        }

        .aurora-2 {
            width: calc(var(--glow-size) * 1.5);
            height: calc(var(--glow-size) * 1.5);
            background: radial-gradient(circle, var(--secondary-color), transparent 60%);
            top: 60%;
            right: 15%;
            animation-duration: 25s;
        }
        
        .aurora-3 {
            width: calc(var(--glow-size) * 1.2);
            height: calc(var(--glow-size) * 1.2);
            background: radial-gradient(circle, #4299ff, transparent 60%);
            bottom: 5%;
            left: 5%;
            animation-duration: 18s;
        }

        @keyframes move-aurora {
            from { transform: translate(0, 0) scale(1); }
            to { transform: translate(50px, 100px) scale(1.3); }
        }

        .container {
            max-width: 500px;
            width: 95%;
            padding: 2rem;
            background: var(--card-bg);
            border-radius: var(--border-radius);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5);
            position: relative;
            z-index: 1;
        }

        .age-gate {
            animation: fadeIn 0.5s ease-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }

        .age-gate h1 {
            font-size: 2.5rem;
            font-weight: 900;
            margin-bottom: 0.5rem;
            color: #fff;
            text-shadow: 0 0 10px var(--secondary-color);
        }

        .age-gate p {
            margin-bottom: 2rem;
            font-size: 1.1rem;
            line-height: 1.6;
        }

        .age-gate .button-group {
            display: flex;
            justify-content: center;
            gap: 1rem;
        }

        .age-gate button {
            font-family: var(--font-family);
            padding: 0.8rem 2rem;
            border-radius: 50px;
            border: none;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 700;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .age-gate .confirm-btn {
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            color: white;
        }
        
        .age-gate .confirm-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(159, 66, 255, 0.5);
        }
        
        .age-gate .exit-btn {
            background: transparent;
            border: 2px solid var(--text-color);
            color: var(--text-color);
        }

        .age-gate .exit-btn:hover {
             background: var(--text-color);
             color: var(--bg-color);
        }

        .banner-content {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .header {
            animation: slideDown 0.6s ease-out;
        }

        @keyframes slideDown {
            from { opacity: 0; transform: translateY(-30px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .header h1 {
            font-size: 2rem;
            font-weight: 900;
            margin-bottom: 0.25rem;
        }

        .header p {
            font-size: 1rem;
            opacity: 0.8;
        }
        
        .gallery-container {
            perspective: 1000px;
        }

        .gallery {
            display: flex;
            gap: 10px;
            padding: 10px;
            overflow-x: auto;
            scrollbar-width: none; /* Firefox */
            -ms-overflow-style: none; /* IE/Edge */
            border-radius: 12px;
            background: rgba(0,0,0,0.2);
            transform-style: preserve-3d;
        }
        
        .gallery::-webkit-scrollbar {
            display: none; /* Chrome/Safari */
        }

        .gallery-item {
            flex: 0 0 120px;
            height: 180px;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.4);
            transition: transform 0.3s ease-out, box-shadow 0.3s ease-out;
            cursor: pointer;
            opacity: 0;
            animation: waterfall-in 0.8s ease-out forwards;
        }

        .gallery-item img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
        }

        .gallery-item:hover {
            transform: translateZ(20px) scale(1.05);
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.6);
        }
        
        @keyframes waterfall-in {
            from { opacity: 0; transform: translateY(50px) rotateX(-20deg); }
            to { opacity: 1; transform: translateY(0) rotateX(0deg); }
        }
        
                .gallery-item:nth-child(1) {
            animation-delay: 0s;
        }
                .gallery-item:nth-child(2) {
            animation-delay: 0.08s;
        }
                .gallery-item:nth-child(3) {
            animation-delay: 0.16s;
        }
                .gallery-item:nth-child(4) {
            animation-delay: 0.24s;
        }
                .gallery-item:nth-child(5) {
            animation-delay: 0.32s;
        }
                .gallery-item:nth-child(6) {
            animation-delay: 0.4s;
        }
                .gallery-item:nth-child(7) {
            animation-delay: 0.48s;
        }
                .gallery-item:nth-child(8) {
            animation-delay: 0.56s;
        }
                .gallery-item:nth-child(9) {
            animation-delay: 0.64s;
        }
                .gallery-item:nth-child(10) {
            animation-delay: 0.72s;
        }
        
        .features ul {
            list-style: none;
            padding: 0;
            margin: 0;
            text-align: right;
            display: flex;
            flex-direction: column;
            gap: 0.8rem;
        }

        .features li {
            background: rgba(255, 255, 255, 0.05);
            padding: 0.8rem 1rem;
            border-radius: 10px;
            font-size: 1.1rem;
            animation: slideUp 0.6s ease-out 0.5s backwards;
        }
        
        @keyframes slideUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .download-section {
             animation: fadeIn 0.6s ease-out 0.8s backwards;
        }

        .download-btn {
            display: inline-block;
            width: 100%;
            padding: 1rem;
            font-family: var(--font-family);
            font-size: 1.5rem;
            font-weight: 900;
            color: white;
            text-decoration: none;
            border-radius: 15px;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            box-shadow: 0 5px 20px rgba(159, 66, 255, 0.4);
            position: relative;
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            animation: pulse 2s infinite;
        }
        
        .download-btn:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(159, 66, 255, 0.6);
            animation-play-state: paused;
        }
        
        .download-btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 300%;
            height: 300%;
            background: rgba(255, 255, 255, 0.15);
            transform: translate(-50%, -50%) rotate(45deg);
            transition: width 0.5s ease, height 0.5s ease;
        }

        .download-btn:hover::before {
            width: 0;
            height: 0;
        }

        @keyframes pulse {
            0% { box-shadow: 0 5px 20px rgba(159, 66, 255, 0.4); }
            50% { box-shadow: 0 5px 35px rgba(255, 59, 141, 0.5); }
            100% { box-shadow: 0 5px 20px rgba(159, 66, 255, 0.4); }
        }

        .file-info {
            display: flex;
            justify-content: space-around;
            margin-top: 1rem;
            font-size: 0.9rem;
            opacity: 0.7;
        }
        
        .downloads-count {
            margin-top: 1rem;
            font-size: 1rem;
            font-weight: 700;
            color: var(--secondary-color);
            text-shadow: 0 0 8px var(--secondary-color);
        }

    </style>
</head>
<body>
    <div class="aurora-background">
        <div class="aurora aurora-1"></div>
        <div class="aurora aurora-2"></div>
        <div class="aurora aurora-3"></div>
    </div>

    <div class="container">
                    <div class="banner-content">
                <header class="header">
                    <h1>بازی جذاب ایرانی</h1>
                    <p>🌐 اولین و بهترین کیس‌ها برای یک تجربه جدید 💦🙈</p>
                </header>

                <div class="gallery-container">
                    <div class="gallery" id="gallery">
                                                    <div class="gallery-item">
                                <img src="https://vasiatnamechie.cyou/g2/IMG_20251021_002514_728.jpg" alt="نمایی از بازی">
                            </div>
                                                    <div class="gallery-item">
                                <img src="https://vasiatnamechie.cyou/g2/IMG_20251021_002514_926.jpg" alt="نمایی از بازی">
                            </div>
                                                    <div class="gallery-item">
                                <img src="https://vasiatnamechie.cyou/g2/IMG_20251021_002514_950.jpg" alt="نمایی از بازی">
                            </div>
                                                    <div class="gallery-item">
                                <img src="https://vasiatnamechie.cyou/g2/IMG_20251021_002514_728.jpg" alt="نمایی از بازی">
                            </div>
                                                    <div class="gallery-item">
                                <img src="https://vasiatnamechie.cyou/g2/IMG_20251021_002515_370.jpg" alt="نمایی از بازی">
                            </div>
              
                                            </div>
                </div>

                <div class="features">
                     <ul>
                                                    <li>تجربه‌های متنوع و هیجان‌انگیز 💦</li>
                                                    <li>داستان‌های گیرا و جذاب 🥰</li>
                                                    <li>صداگذاری‌های حرفه‌ای و تاثیرگذار 👄</li>
                                                    <li>مراحل چالشی و جدید 🥵</li>
                                                    <li>و ده‌ها ویژگی پنهان دیگر... 🤤</li>
                                            </ul>
                </div>

                <div class="download-section">
                    <a href="?download=true" class="download-btn">📥 دانلود و نصب مستقیم</a>
                    <div class="file-info">
                        <span>8.جم: 8 MB</span>
                        <span>اندروید: 4.4+</span>
                    </div>
                                            <p class="downloads-count">🔥 1193
            </div>
            </div>
    
        <script>
        const gallery = document.getElementById('gallery');
        gallery.addEventListener('mousemove', (e) => {
            const { clientX, clientY, currentTarget } = e;
            const { top, left, width, height } = currentTarget.getBoundingClientRect();
            
            const xRotation = 20 * ((clientY - top - height / 2) / height);
            const yRotation = -20 * ((clientX - left - width / 2) / width);

            currentTarget.style.transform = `rotateX(${xRotation}deg) rotateY(${yRotation}deg)`;
        });

        gallery.addEventListener('mouseleave', () => {
            gallery.style.transform = `rotateX(0) rotateY(0)`;
        });>
    </body>
</html>


