
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل کاربری - بازی سکسی</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #6A11CB;
            --primary-hover: #4A00E0;
            --secondary: #F0F0F0;
            --accent: #FF6B8B;
            --light: #FAFAFA;
            --dark: #2D3436;
            --success: #00B894;
            --border-radius: 20px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazirmatn', sans-serif;
        }

        body {
            background: linear-gradient(-20deg, #6A11CB 0%, #4A00E0 100%);
            color: #2D3436;
            min-height: 100vh;
            padding: 20px 0;
            background-attachment: fixed;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        /* هدر و منو */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border-radius: var(--border-radius);
            padding: 15px 25px;
            margin-bottom: 30px;
            box-shadow: var(--box-shadow);
        }

        .logo {
            font-weight: 800;
            font-size: 1.8rem;
            color: white;
            display: flex;
            align-items: center;
        }

        .menu-icon {
            font-size: 1.5rem;
            color: white;
            cursor: pointer;
            transition: var(--transition);
        }

        .menu-icon:hover {
            transform: rotate(90deg);
        }

        /* محتوای اصلی */
        .main-content {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            margin-bottom: 30px;
        }

        .status-section {
            padding: 40px;
            text-align: center;
            background: linear-gradient(135deg, #fdfcfb 0%, #f5f7fa 100%);
        }

        .status-icon {
            font-size: 4rem;
            margin-bottom: 20px;
            color: var(--primary);
        }

        .status-title {
            font-weight: 800;
            font-size: 2rem;
            color: var(--primary);
            margin-bottom: 15px;
        }

        .status-text {
            font-size: 1.2rem;
            color: #666;
            line-height: 1.8;
            margin-bottom: 10px;
        }

        .login-btn {
            background: var(--primary);
            color: white;
            padding: 12px 30px;
            border-radius: 50px;
            display: inline-block;
            margin: 20px 0;
            font-weight: 600;
            font-size: 1.2rem;
            cursor: pointer;
            transition: var(--transition);
            border: none;
        }

        .login-btn:hover {
            background: var(--primary-hover);
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        /* بخش پلن‌ها */
        .plans-section {
            padding: 40px;
            background: white;
        }

        .section-title {
            font-weight: 700;
            color: var(--primary);
            font-size: 1.8rem;
            margin-bottom: 30px;
            text-align: center;
        }

        .plans-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
        }

        .plan-card {
            background: var(--light);
            border-radius: var(--border-radius);
            padding: 25px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: var(--transition);
            position: relative;
            cursor: pointer;
            border: 2px solid transparent;
        }

        .plan-card.locked {
            opacity: 0.7;
        }

        .plan-card.locked:after {
            content: "🔒";
            position: absolute;
            top: 15px;
            left: 15px;
            font-size: 1.5rem;
        }

        .plan-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            border-color: var(--primary);
        }

        .plan-icon {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: var(--primary);
        }

        .plan-title {
            font-weight: 700;
            font-size: 1.3rem;
            margin-bottom: 10px;
            color: var(--dark);
        }

        .plan-description {
            color: #666;
            line-height: 1.6;
        }

        /* پنل پروفایل */
        .profile-panel {
            position: fixed;
            top: 0;
            right: -400px;
            width: 380px;
            height: 100vh;
            background: white;
            box-shadow: -5px 0 25px rgba(0, 0, 0, 0.15);
            z-index: 1000;
            transition: var(--transition);
            padding: 30px;
            overflow-y: auto;
        }

        .profile-panel.active {
            right: 0;
        }

        .panel-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #eee;
        }

        .panel-title {
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary);
        }

        .close-panel {
            font-size: 1.5rem;
            color: #999;
            cursor: pointer;
            transition: var(--transition);
        }

        .close-panel:hover {
            color: var(--accent);
            transform: rotate(90deg);
        }

        .profile-info {
            margin-bottom: 30px;
        }

        .info-group {
            margin-bottom: 20px;
        }

        .info-label {
            font-weight: 600;
            color: #666;
            margin-bottom: 5px;
            display: block;
        }

        .info-value {
            font-size: 1.1rem;
            color: var(--dark);
            padding: 10px 15px;
            background: #f9f9f9;
            border-radius: var(--border-radius);
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            display: none;
        }

        .overlay.active {
            display: block;
        }

        /* مودال ورود */
        .login-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 10000;
            display: none;
            justify-content: center;
            align-items: center;
        }

        .login-modal.active {
            display: flex;
        }

        .login-content {
            background-color: white;
            border-radius: var(--border-radius);
            width: 90%;
            max-width: 500px;
            padding: 30px;
            box-shadow: var(--box-shadow);
            animation: modalFadeIn 0.3s ease;
        }

        @keyframes modalFadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-header {
            text-align: center;
            margin-bottom: 20px;
        }

        .login-title {
            font-weight: 700;
            color: var(--primary);
            font-size: 1.8rem;
            margin-bottom: 10px;
        }

        .login-form {
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--dark);
            display: block;
        }

        .form-input {
            width: 100%;
            padding: 1rem 1.2rem;
            border-radius: var(--border-radius);
            border: 2px solid #eaeaea;
            transition: var(--transition);
            font-size: 1rem;
        }

        .form-input:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.25rem rgba(106, 17, 203, 0.25);
            outline: none;
        }

        .form-input.error {
            border-color: var(--accent);
        }

        .error-message {
            color: var(--accent);
            font-size: 0.9rem;
            margin-top: 5px;
            display: none;
        }

        .captcha-container {
            display: flex;
            align-items: center;
            margin-bottom: 1.5rem;
            padding: 10px;
            background: #f9f9f9;
            border-radius: var(--border-radius);
        }

        .captcha-container input {
            margin-left: 10px;
        }

        .login-footer {
            text-align: center;
        }

        .submit-btn {
            background: linear-gradient(to right, var(--primary) 0%, var(--primary-hover) 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            font-size: 1.1rem;
        }

        .submit-btn:hover {
            background: linear-gradient(to right, var(--primary-hover) 0%, #3a00a0 100%);
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        /* مودال ارور */
        .modal {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            border-radius: var(--border-radius);
            padding: 30px;
            box-shadow: var(--box-shadow);
            z-index: 1001;
            text-align: center;
            display: none;
            width: 90%;
            max-width: 400px;
        }

        .modal.active {
            display: block;
        }

        .modal-icon {
            font-size: 3rem;
            color: var(--accent);
            margin-bottom: 20px;
        }

        .modal-title {
            font-weight: 700;
            font-size: 1.5rem;
            margin-bottom: 15px;
            color: var(--dark);
        }

        .modal-text {
            color: #666;
            line-height: 1.6;
            margin-bottom: 25px;
        }

        .modal-close {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }

        .modal-close:hover {
            background: var(--primary-hover);
            transform: translateY(-3px);
        }

        /* رسپانسیو */
        @media (max-width: 768px) {
            .plans-grid {
                grid-template-columns: 1fr;
            }
            
            .profile-panel {
                width: 100%;
                right: -100%;
            }
            
            .status-section {
                padding: 25px;
            }
            
            .status-title {
                font-size: 1.6rem;
            }
            
            .login-content {
                padding: 20px;
            }
            .close-modal {
    position: absolute;
    top: 15px;
    left: 15px;
    font-size: 1.5rem;
    color: #999;
    cursor: pointer;
    transition: var(--transition);
    z-index: 1;
}

.close-modal:hover {
    color: var(--accent);
    transform: rotate(90deg);
}

.login-header {
    position: relative;
    text-align: center;
    margin-bottom: 20px;
    padding-top: 10px;
}
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- هدر و منو -->
        <div class="header">
            <div class="logo">🎮 بازی سکسی</div>
            <div class="menu-icon" onclick="openProfilePanel()">
                <i class="fas fa-bars"></i>
            </div>
        </div>

        <!-- محتوای اصلی -->
        <div class="main-content">
            <!-- بخش وضعیت -->
            <div class="status-section">
                <div class="status-icon">⏳</div>
                <h1 class="status-title">در انتظار فعال سازی</h1>
                <p class="status-text">اشتراک شما توسط ادمین ما در حال بررسی و فعال سازی است.</p>
                <p class="status-text">پس از فعال سازی، اطلاعات ورود اکانت شما به شماره ای که در بخش قبل وارد کردید ارسال خواهد شد:</p>
                <p class="status-text">لطفا تا دریافت اطلاعات اکانت، شکیبا باشید.</p>
                <button class="login-btn" onclick="openLoginModal()">ورود به پنل کاربری</button>
            </div>

            <!-- بخش پلن‌ها -->
            <div class="plans-section">
                <h2 class="section-title">پلن‌های بازی ما</h2>
                <div class="plans-grid">
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">👭</div>
                        <h3 class="plan-title">لزبین</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک لزبین</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">🌈</div>
                        <h3 class="plan-title">گی</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک گی</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">👨‍👩‍👧</div>
                        <h3 class="plan-title">تری سام</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک تری سام</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">🧘‍♂️</div>
                        <h3 class="plan-title">ریلکس و مدرن</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک ریلکس و مدرن</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">💆‍♂️</div>
                        <h3 class="plan-title">ماساژی</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک ماساژی</p>
                    </div>
                    <div class="plan-card locked" onclick="showError()">
                        <div class="plan-icon">🔥</div>
                        <h3 class="plan-title">خشن</h3>
                        <p class="plan-description">تجربه بازی برای علاقه‌مندان به سبک خشن</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- پنل پروفایل -->
    <div class="profile-panel" id="profilePanel">
        <div class="panel-header">
            <h2 class="panel-title">پروفایل کاربری</h2>
            <div class="close-panel" onclick="closeProfilePanel()">
                <i class="fas fa-times"></i>
            </div>
        </div>

        <div class="profile-info">
            <div class="info-group">
                <label class="info-label">نام کاربری در بازی</label>
                <div class="info-value" id="profile-username">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">نام</label>
                <div class="info-value" id="profile-firstname">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">نام خانوادگی</label>
                <div class="info-value" id="profile-lastname">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">ایمیل</label>
                <div class="info-value" id="profile-email">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">شماره تلفن</label>
                <div class="info-value" id="profile-phone">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">سن</label>
                <div class="info-value" id="profile-age">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">جنسیت</label>
                <div class="info-value" id="profile-gender">شما هنوز وارد نشده اید</div>
            </div>
            <div class="info-group">
                <label class="info-label">سبک بازی انتخاب شده</label>
                <div class="info-value" id="profile-style">شما هنوز وارد نشده اید</div>
            </div>
        </div>
        
        <div class="sticker-placeholder">
            <img src="/game1/gif.gif" alt="استیکر" style="max-width: 100%; border-radius: 10px;">
            <p style="margin-top: 10px; color: #666;">تمامی حقوق محفوظ است</p>
        </div>
    </div>

    <!-- مودال ورود -->
    <div class="login-modal" id="loginModal">
        <div class="login-content">
            <div class="login-header">
                  <!-- اضافه کردن دکمه ضربدر در اینجا -->
            <div class="close-modal" onclick="closeModals()">
                <i class="fas fa-times"></i>
            </div>
                <h2 class="login-title">ورود به پنل کاربری</h2>
                <p>لطفا اطلاعات خود را وارد کنید</p>
            </div>
            
            <form class="login-form" id="loginForm">
                <div class="form-group">
                    <label class="form-label">نام کاربری در بازی</label>
                    <input type="text" class="form-input" id="login-username" placeholder="نام کاربری خود را وارد کنید">
                    <div class="error-message" id="username-error"></div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">رمز عبور</label>
                    <input type="password" class="form-input" id="login-password" placeholder="رمز عبور خود را وارد کنید">
                    <div class="error-message" id="password-error"></div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">کد اشتراک</label>
                    <input type="text" class="form-input" id="login-code" placeholder="کد اشتراک خود را وارد کنید">
                    <div class="error-message" id="code-error"></div>
                </div>
                
                <div class="captcha-container">
                    <input type="checkbox" id="login-captcha">
                    <label for="login-captcha">من ربات نیستم</label>
                    <div class="error-message" id="captcha-error"></div>
                </div>
            </form>
            
            <div class="login-footer">
                <button class="submit-btn" onclick="validateLogin()">ورود به پنل</button>
            </div>
        </div>
    </div>

    <!-- overlay -->
    <div class="overlay" id="overlay" onclick="closeModals()"></div>

    <!-- مودال خطا -->
    <div class="modal" id="errorModal">
        <div class="modal-icon">⛔</div>
        <h2 class="modal-title">اشتراک فعال نیست</h2>
        <p class="modal-text">اشتراک شما هنوز فعال نشده است. لطفا تا فعال شدن اشتراک منتظر بمانید.</p>
        <button class="modal-close" onclick="closeModal()">متوجه شدم</button>
    </div>

    <script>
        // نمایش اطلاعات کاربر از PHP
        const userData = {
            username: "<?php echo $userData['username']; ?>",
            firstname: "<?php echo $userData['firstname']; ?>",
            lastname: "<?php echo $userData['lastname']; ?>",
            email: "<?php echo $userData['email']; ?>",
            phone: "<?php echo $userData['phone']; ?>",
            age: "<?php echo $userData['age']; ?>",
            gender: "<?php echo $userData['gender']; ?>",
            style: "<?php echo $userData['style']; ?>"
        };

        // باز کردن مودال ورود
        function openLoginModal() {
            document.getElementById('loginModal').classList.add('active');
            document.getElementById('overlay').classList.add('active');
        }
        
        // بستن همه مودال‌ها
        function closeModals() {
            document.getElementById('loginModal').classList.remove('active');
            document.getElementById('errorModal').classList.remove('active');
            document.getElementById('profilePanel').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }
        
        // اعتبارسنجی فرم ورود
        function validateLogin() {
            const username = document.getElementById('login-username').value;
            const password = document.getElementById('login-password').value;
            const code = document.getElementById('login-code').value;
            const captcha = document.getElementById('login-captcha').checked;
            
            let isValid = true;
            
            // پاک کردن خطاهای قبلی
            document.getElementById('username-error').style.display = 'none';
            document.getElementById('password-error').style.display = 'none';
            document.getElementById('code-error').style.display = 'none';
            document.getElementById('captcha-error').style.display = 'none';
            
            // اعتبارسنجی نام کاربری
            if (!username) {
                document.getElementById('username-error').textContent = 'لطفا نام کاربری را وارد کنید';
                document.getElementById('username-error').style.display = 'block';
                isValid = false;
            }
            
            // اعتبارسنجی رمز عبور
            if (!password) {
                document.getElementById('password-error').textContent = 'لطفا رمز عبور را وارد کنید';
                document.getElementById('password-error').style.display = 'block';
                isValid = false;
            }
            
            // اعتبارسنجی کد اشتراک
            if (!code) {
                document.getElementById('code-error').textContent = 'لطفا کد اشتراک را وارد کنید';
                document.getElementById('code-error').style.display = 'block';
                isValid = false;
            } else if (code !== 'adsgame120') {
                document.getElementById('code-error').textContent = 'کد شما اشتباه است لطفا کد پیامک شده را به درستی وارد کنید';
                document.getElementById('code-error').style.display = 'block';
                isValid = false;
            }
            
            // اعتبارسنجی کپچا
            if (!captcha) {
                document.getElementById('captcha-error').textContent = 'لطفا دکمه تشخیص انسان بودن را بزنید';
                document.getElementById('captcha-error').style.display = 'block';
                isValid = false;
            }
            
            if (isValid) {
                // اگر اطلاعات درست باشد، پنل کاربری را پر کنیم
                document.getElementById('profile-username').textContent = userData.username;
                document.getElementById('profile-firstname').textContent = userData.firstname;
                document.getElementById('profile-lastname').textContent = userData.lastname;
                document.getElementById('profile-email').textContent = userData.email;
                document.getElementById('profile-phone').textContent = userData.phone;
                document.getElementById('profile-age').textContent = userData.age;
                document.getElementById('profile-gender').textContent = userData.gender;
                document.getElementById('profile-style').textContent = userData.style;
                
                // بستن مودال ورود
                closeModals();
                
                // باز کردن پنل پروفایل
                openProfilePanel();
            }
        }

        // باز کردن پنل پروفایل
        function openProfilePanel() {
            document.getElementById('profilePanel').classList.add('active');
            document.getElementById('overlay').classList.add('active');
        }

        // بستن پنل پروفایل
        function closeProfilePanel() {
            document.getElementById('profilePanel').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }

        // نمایش خطا هنگام کلیک روی پلن‌ها
        function showError() {
            document.getElementById('errorModal').classList.add('active');
            document.getElementById('overlay').classList.add('active');
        }

        // بستن مودال
        function closeModal() {
            document.getElementById('errorModal').classList.remove('active');
            document.getElementById('overlay').classList.remove('active');
        }
        
    </script>
</body>
</html>