<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فرم پیشرفته بازی</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #6A11CB;
            --primary-hover: #4A00E0;
            --secondary: #F0F0F0;
            --accent: #FF6B8B;
            --light: #FAFAFA;
            --dark: #2D3436;
            --success: #00B894;
            --error: #ff4757;
            --border-radius: 20px;
            --box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazirmatn', sans-serif;
        }

        body {
            background: linear-gradient(-20deg, #6A11CB 0%, #4A00E0 100%);
            color: #2D3436;
            line-height: 1.8;
            min-height: 100vh;
            padding: 20px 0;
            background-attachment: fixed;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        .card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
            margin-bottom: 30px;
        }

        .header {
            background: linear-gradient(to right, var(--primary) 0%, var(--primary-hover) 100%);
            color: white;
            padding: 25px 30px;
            text-align: center;
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }

        .header h1 {
            font-weight: 800;
            font-size: 2.5rem;
            margin-bottom: 10px;
        }

        .header p {
            font-size: 1.2rem;
            opacity: 0.9;
        }

        .content {
            padding: 30px;
        }

        .section-title {
            font-weight: 700;
            color: var(--primary);
            font-size: 1.5rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
        }

        .section-title strong {
            background: var(--primary);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.9rem;
            margin-left: 10px;
        }

        .options-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }

        .option-card {
            background: var(--light);
            padding: 20px;
            border-radius: var(--border-radius);
            margin-bottom: 1rem;
            border: 2px solid transparent;
            transition: var(--transition);
            cursor: pointer;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
        }

        .option-card:hover {
            border-color: var(--primary);
            transform: translateX(8px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        }

        .option-card.selected {
            border-color: var(--primary);
            background-color: rgba(106, 17, 203, 0.05);
        }

        .checkmark {
            width: 28px;
            height: 28px;
            border-radius: 50%;
            border: 2px solid #ccc;
            margin-left: 15px;
            display: flex;
            justify-content: center;
            align-items: center;
            transition: var(--transition);
        }

        .option-card.selected .checkmark {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        .checkmark:after {
            content: "✓";
            color: white;
            font-weight: bold;
            display: none;
        }

        .option-card.selected .checkmark:after {
            display: block;
        }

        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }

        .input-title {
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--dark);
            display: block;
        }

        .form-control {
            width: 100%;
            padding: 1.2rem 1.5rem;
            border-radius: var(--border-radius);
            border: 2px solid #eaeaea;
            transition: var(--transition);
            font-size: 1rem;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 0.25rem rgba(106, 17, 203, 0.25);
            outline: none;
        }

        .form-control.error {
            border-color: var(--error);
        }

        .error-message {
            color: var(--error);
            font-size: 0.8rem;
            margin-top: 5px;
            display: none;
        }

        .age-slider {
            padding: 1rem 0;
            position: relative;
        }

        .age-slider input[type="range"] {
            width: 100%;
            border-radius: 10px;
            height: 12px;
            background: #eee;
            outline: none;
            -webkit-appearance: none;
        }

        .age-slider input[type="range"]::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            background: var(--primary);
            width: 30px;
            height: 30px;
            border-radius: 50%;
            cursor: pointer;
            box-shadow: 0 4px 10px rgba(0,0,0,0.2);
            border: 3px solid white;
        }

        .age-slider input[type="range"]::-webkit-slider-runnable-track {
            height: 12px;
            border-radius: 10px;
            background: linear-gradient(to left, var(--primary) 0%, var(--primary) var(--slider-progress, 50%), #eee var(--slider-progress, 50%), #eee 100%);
        }

        .age-value {
            display: block;
            text-align: center;
            font-weight: 600;
            margin-top: 1rem;
            font-size: 1.2rem;
            color: var(--primary);
        }

        .terms {
            padding: 1.5rem;
            background: #f9f9f9;
            border-radius: var(--border-radius);
            border: 2px dashed #ddd;
            margin-top: 20px;
        }

        .terms a {
            color: var(--primary);
            font-weight: 600;
            text-decoration: underline;
        }

        .terms.error {
            border-color: var(--error);
        }

        .btn {
            padding: 1rem 2.2rem;
            border-radius: 50px;
            font-weight: 700;
            transition: var(--transition);
            font-size: 1rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            border: none;
        }

        .btn-back {
            background-color: #f1f3f5;
            color: #495057;
            border: 2px solid #dee2e6;
        }

        .btn-back:hover {
            background-color: #e9ecef;
            color: #212529;
            border-color: #adb5bd;
        }

        .btn-next {
            background: linear-gradient(to right, var(--primary) 0%, var(--primary-hover) 100%);
            color: white;
            box-shadow: 0 5px 15px rgba(106, 17, 203, 0.3);
        }

        .btn-next:disabled {
            background: #ccc;
            cursor: not-allowed;
            box-shadow: none;
        }

        .btn-payment {
            background: linear-gradient(to right, var(--accent) 0%, #ff537b 100%);
            color: white;
            box-shadow: 0 5px 15px rgba(255, 107, 139, 0.3);
            padding: 1.2rem 2.5rem;
            font-size: 1.1rem;
        }

        .btn:hover:not(:disabled) {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }

        .navigation {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }

        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }

        .step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #eaeaea;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 5px;
            font-weight: bold;
        }

        .step.active {
            background: var(--primary);
            color: white;
        }

        .step-complete {
            background: var(--success);
            color: white;
        }

        .progress-bar {
            height: 10px;
            border-radius: 5px;
            background: #eaeaea;
            margin-bottom: 30px;
            overflow: hidden;
        }

        .progress {
            height: 100%;
            background: linear-gradient(to right, var(--primary) 0%, var(--primary-hover) 100%);
            border-radius: 5px;
            transition: width 0.5s ease;
        }

        .sticker-placeholder {
            text-align: center;
            margin: 20px 0;
            padding: 0;
            background: rgba(106, 17, 203, 0.05);
            border-radius: var(--border-radius);
            border: 2px dashed rgba(106, 17, 203, 0.2);
            overflow: hidden;
            height: 100px;
        }

        .sticker-placeholder video {
            width: 100%;
            height: 200px;
            object-fit: cover;
            object-position: center;
            margin-top: -80px;
            border-radius: 10px;
        }

        .summary {
            background: linear-gradient(135deg, #fdfcfb 0%, #f5f7fa 100%);
            padding: 2.5rem;
            border-radius: var(--border-radius);
            border-left: 5px solid var(--accent);
        }

        .summary h5 {
            color: var(--primary);
            font-weight: 700;
            margin-top: 1.5rem;
            font-size: 1.3rem;
            display: flex;
            align-items: center;
        }

        .summary h5:first-child {
            margin-top: 0;
        }

        .summary p {
            color: #666;
            line-height: 1.9;
            margin-bottom: 1.5rem;
        }

        @media (max-width: 768px) {
            .options-grid {
                grid-template-columns: 1fr;
            }
            
            .navigation {
                flex-direction: column;
                gap: 15px;
            }
            
            .btn {
                width: 100%;
            }
            /* استایل مودال سفارشی */
        
        /* استایل مودال قوانین */
        .terms-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 10000;
            justify-content: center;
            align-items: center;
        }
        
        .terms-modal.active {
            display: flex;
        }
        
        .modal-content {
            background-color: white;
            border-radius: var(--border-radius);
            width: 90%;
            max-width: 600px;
            max-height: 80vh;
            overflow-y: auto;
            box-shadow: var(--box-shadow);
            animation: modalFadeIn 0.3s ease;
        }
        
        @keyframes modalFadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .modal-header {
            padding: 15px 20px;
            border-bottom: 1px solid #eee;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(to right, var(--primary) 0%, var(--primary-hover) 100%);
            color: white;
            border-radius: var(--border-radius) var(--border-radius) 0 0;
        }
        
        .modal-title {
            font-weight: 700;
            font-size: 1.3rem;
            margin: 0;
        }
        
        .close-modal {
            font-size: 1.5rem;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .close-modal:hover {
            transform: rotate(90deg);
            color: var(--accent);
        }
        
        .modal-body {
            padding: 20px;
            line-height: 1.8;
        }
        
        .modal-body p {
            margin-bottom: 15px;
            color: #555;
        }
        
        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid #eee;
            text-align: left;
        }
        
        .agree-btn {
            background: linear-gradient(to right, var(--primary) 0%, var(--primary-hover) 100%);
            color: white;
            border: none;
            padding: 10px 25px;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        
        .agree-btn:hover {
            background: linear-gradient(to right, var(--primary-hover) 0%, #3a00a0 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        
        @media (max-width: 768px) {
            .modal-content {
                width: 95%;
                margin: 10px;
            }
       

.close {
    font-size: 24px;
    font-weight: bold;
    cursor: pointer;
}

.btn_1 {
    background: var(--primary);
    color: white;
    border: none;
    padding: 8px 20px;
    border-radius: 5px;
    cursor: pointer;
}
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="header">
                <h1>✨ بازی سکسی</h1>
                <p>بازی با سلیقه شما ؛ رضایت بیشتر شما💞</p>
            </div>

            <div class="content">
                <div class="progress-bar">
                    <div class="progress" style="width: 20%;"></div>
                </div>

                <div class="step-indicator">
                    <div class="step active">1</div>
                    <div class="step">2</div>
                    <div class="step">3</div>
                    <div class="step">4</div>
                    <div class="step">5</div>
                </div>

                <!-- Step 1 -->
                <div class="step-content" id="step1">
                    <h3 class="section-title"><strong>1/5</strong>سبک بازی خود را انتخاب کنید 🎯</h3>
                    
                    <div class="sticker-placeholder">
                        <img src="/g/gif.gif" alt="استیکر سبک بازی" style="max-width: 100%; border-radius: 10px;">
                    </div>
                    
                    <div class="options-grid">
                        <div class="option-card" onclick="toggleSelection(this, 'question_1')">
                            <div class="checkmark"></div>
                            <div class="option-text">لزبین 👭</div>
                        </div>
                        <div class="option-card" onclick="toggleSelection(this, 'question_1')">
                            <div class="checkmark"></div>
                            <div class="option-text">گی 🌈</div>
                        </div>
                        <div class="option-card" onclick="toggleSelection(this, 'question_1')">
                            <div class="checkmark"></div>
                            <div class="option-text">تری سام 👨‍👩‍👧</div>
                        </div>
                        <div class="option-card" onclick="toggleSelection(this, 'question_1')">
                            <div class="checkmark"></div>
                            <div class="option-text">ریلکس و مدرن 🧘‍♂️</div>
                        </div>
                        <div class="option-card" onclick="toggleSelection(this, 'question_1')">
                            <div class="checkmark"></div>
                            <div class="option-text">ماساژی 💆‍♂️</div>
                        </div>
                        <div class="option-card" onclick="toggleSelection(this, 'question_1')">
                            <div class="checkmark"></div>
                            <div class="option-text">خشن 🔥</div>
                        </div>
                    </div>
                    <div class="error-message" id="step1-error"></div>

                    <div class="navigation">
                        <button class="btn btn-back" onclick="prevStep()">⏪ بازگشت</button>
                        <button class="btn btn-next" onclick="validateStep1()">ادامه ⏩</button>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="step-content" id="step2" style="display: none;">
                    <h3 class="section-title"><strong>2/5</strong>لطفا جنسیت خود را انتخاب کنید 👤</h3>
                    
                    <div class="sticker-placeholder">
                        <img src="/g/gif.gif" alt="استیکر سبک بازی" style="max-width: 100%; border-radius: 10px;">
                    </div>
                    
                    <div class="form-group">
                        <label class="input-title">جنسیت</label>
                        <select class="form-control" id="gender">
                            <option value="">-- انتخاب کنید --</option>
                            <option value="male">آقا 👨</option>
                            <option value="female">خانم 👩</option>
                        </select>
                        <div class="error-message" id="gender-error"></div>
                    </div>

                    <div class="navigation">
                        <button class="btn btn-back" onclick="prevStep()">⏪ بازگشت</button>
                        <button class="btn btn-next" onclick="validateStep2()">ادامه ⏩</button>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="step-content" id="step3" style="display: none;">
                    <h3 class="section-title"><strong>3/5</strong>سن خود را انتخاب کنید 🎂</h3>
                    
                         <div class="sticker-placeholder">
                        <img src="/g/gif.gif" alt="استیکر سبک بازی" style="max-width: 100%; border-radius: 10px;">
                    </div>
                    
                    <div class="age-slider">
                        <input type="range" min="18" max="70" value="18" class="slider" id="ageRange" oninput="updateAgeValue(this.value)">
                        <span class="age-value" id="ageValue">18 سال</span>
                    </div>

                    <div class="navigation">
                        <button class="btn btn-back" onclick="prevStep()">⏪ بازگشت</button>
                        <button class="btn btn-next" onclick="validateStep3()">ادامه ⏩</button>
                    </div>
                </div>

                <!-- Step 4 -->
                            <div class="step-content" id="step4" style="display: none;">
                                
                    <h3 class="section-title"><strong>4/5</strong>نتیجه درخواست 📋</h3>
                    
                       <div class="sticker-placeholder">
                        <img src="/g/gif.gif" alt="استیکر سبک بازی" style="max-width: 100%; border-radius: 10px;">
                    </div>
                    
                    <div class="summary">
                        <ul>
                            <li><strong>✅ تقریباً تمام شد!</strong>
                                <h5>🎮 شروع بازی با سبک ساخته شده</h5>
                                <h5>⏰ 1 تا 3 ساعت بعد از خرید، اشتراک شما فعال شده و اطلاعات اکانت به شماره‌ای که وارد کردید پیامک خواهد شد</h5>	
                                <p>👤 کاربر عزیز، برای شروع بازی با سلیقه خود ابتدا ۱۰,۰۰۰ تومان را پرداخت کنید</p>           
                                <h5>🎁 تا پایان تابستان بازی ما رایگان خواهد بود و هزینه ناچیز اشتراک صرفاً برای احراز هویت و تشخیص ربات نبودن کاربران خواهد بود</h5>
                                <p>🔐 این هزینه برای تایید هویت شما میباشد و بازی به مدت یکماه بدون نیاز به پرداخت مجدد، در اختیار شما قرار میگیرد. بعد از پرداخت و دریافت بازی، امکان تغییر سلیقه و سبک بازی نیز میباشد.</p>
                                <h5>⚖️  میتوانید با پشتیبانی تلگرام به آیدی : @GameSexyAdmin درصورت بودن هر گونه مشکل و  یا جهت فعال سازی اشتراک ارتباط بگیرید.</h5>
                                <p>⏳ لطفا یک بار کلیک کنید و 5-10 ثانیه صبر کنید!</p>
                            </li>
                        </ul>
                    </div>

                   <div class="navigation">
        <button class="btn btn-back" onclick="prevStep()">⏪ بازگشت</button>
        <button class="btn btn-next" onclick="validateStep3()">ادامه ⏩</button>
    </div>
</div>
                    <!-- Step 5 -->
            <div class="step-content" id="step5" style="display: none;">
                <h3 class="section-title"><strong>5/5</strong>لطفا اطلاعات خود را وارد کنید 📝</h3>
                
                               <div class="sticker-placeholder">
                        <img src="/g/gif.gif" alt="استیکر سبک بازی" style="max-width: 100%; border-radius: 10px;">
                    </div>
                
                <!-- تغییر در فرم: اضافه کردن onsubmit و تغییر type دکمه -->
                <form action="submit.php" method="POST" id="mainForm" onsubmit="return validateAndSubmit()">
                    <!-- فیلدهای مخفی برای ذخیره داده‌های مراحل قبل -->
                    <input type="hidden" name="gender" id="hiddenGender">
                    <input type="hidden" name="age" id="hiddenAge">
                    <input type="hidden" name="gameStyle" id="hiddenGameStyle">
                    
                    <div class="form-group">
                        <label class="input-title">نام شما در بازی 🎮</label>
                        <input type="text" class="form-control" id="gameUsername" name="gameUsername" placeholder="نامی که در بازی نمایش داده می‌شود">
                        <div class="error-message" id="gameUsername-error"></div>
                    </div>
                    <div class="form-group">
                        <label class="input-title">نام 👤</label>
                        <input type="text" class="form-control" id="firstname" name="firstname" placeholder="نام واقعی خود را وارد کنید">
                        <div class="error-message" id="firstname-error"></div>
                    </div>
                    <div class="form-group">
                        <label class="input-title">نام خانوادگی 👥</label>
                        <input type="text" class="form-control" id="lastname" name="lastname" placeholder="نام خانوادگی خود را وارد کنید">
                        <div class="error-message" id="lastname-error"></div>
                    </div>
                    <div class="form-group">
                        <label class="input-title">ایمیل 📧 (اختیاری)</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="ایمیل خود را وارد کنید">
                    </div>
                    <div class="form-group">
                        <label class="input-title">شماره موبایل 📱</label>
                        <input type="text" class="form-control" id="phone" name="phone" placeholder="09xxxxxxxxx" maxlength="11">
                        <div class="error-message" id="phone-error"></div>
                        <small style="color: #666; font-size: 0.9rem;">شماره باید با 09 شروع شده و 11 رقمی باشد</small>
                    </div>
                    <div class="form-group">
                        <label class="input-title">رمز عبور 🔒</label>
                        <input type="password" class="form-control" id="password" name="password" placeholder="رمز عبور خود را انتخاب کنید">
                        <div class="error-message" id="password-error"></div>
                    </div>
                    
          <div class="terms" id="terms-container">
                    <label>
                        <input type="checkbox" id="terms" name="terms"> با <a href="#" onclick="showTermsModal()">قوانین و مقررات</a> موافقم 📜
                    </label>
                    <div class="error-message" id="terms-error"></div>
                </div>
                    <div class="navigation">
                        <button class="btn btn-back" onclick="prevStep()">⏪ بازگشت</button>
                        <!-- تغییر type از submit به button -->
                        <button type="button" class="btn btn-next" onclick="validateAndSubmit()">💳 ثبت و خرید اشتراک بازی</button>
                    </div>
                </div>
            </div>
     </div>
    <!-- مودال قوانین و مقررات -->
    <div class="terms-modal" id="termsModal">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">قوانین و سیاست ها</h4>
                <span class="close-modal" onclick="closeTermsModal()">&times;</span>
            </div>
            <div class="modal-body">
                <p>🧘‍♂ قوانین رزرو و ارائه خدمات بازی سکسی:</p>
                <p>⚖️ هزینه ۱۰,۰۰۰ تومان جهت رزرو نهایی از شما دریافت می‌گردد و این هزینه جهت اطمینان از واقعی بودن درخواست شما است.</p>
                <p>⚖️ بعد از پرداخت هزینه میتوانید با پشتیبانی تلگرام به آیدی : @GameSexyAdmin جهت دریافت آپدیت ها و فعال سازی اشتراک ارتباط بگیرید.</p>
                <p>⚖️ اگر مایل به کنسل رزرو خود هستید شماره کارت و شماره موبایل خود را به پشتیبانی تلگرام ارسال کنید مبلغ 5 هزار تومان به حساب شما برگردانده شود.</p>
                <p>⚖️ هیچ گونه هزینه ایاب و ذهاب‌ی دریافت نمی‌گردد در صورت مشاهده به پشتیبانی تلگرام اطلاع دهید.</p>
            </div>
            <div class="modal-footer">
                <button class="agree-btn" onclick="agreeToTerms()">موافقم و می‌بندم</button>
            </div>
        </div>
    </div>


    <!-- Modal terms -->
  
    <script>
        let currentStep = 1;
        const totalSteps = 5;
        let selectedOptions = {
            question_1: []
        };

        function updateAgeValue(value) {
            document.getElementById('ageValue').textContent = value + ' سال';
            
            // محاسبه درصد پیشرفت
            const min = 18;
            const max = 70;
            const progress = ((value - min) / (max - min)) * 100;
            
            // اعمال درصد پیشرفت به اسلایدر (از راست به چپ)
            const slider = document.getElementById('ageRange');
            slider.style.background = `linear-gradient(to left, var(--primary) 0%, var(--primary) ${progress}%, #eee ${progress}%, #eee 100%)`;
        }

        function toggleSelection(element, questionName) {
            element.classList.toggle('selected');
            const optionText = element.querySelector('.option-text').textContent;
            
            if (element.classList.contains('selected')) {
                selectedOptions[questionName].push(optionText);
            } else {
                const index = selectedOptions[questionName].indexOf(optionText);
                if (index > -1) {
                    selectedOptions[questionName].splice(index, 1);
                }
            }
        }
   // تابع برای نمایش مودال قوانین
        function showTermsModal() {
            document.getElementById('termsModal').classList.add('active');
        }
        
        // تابع برای بستن مودال قوانین
        function closeTermsModal() {
            document.getElementById('termsModal').classList.remove('active');
        }
        
        // تابع برای موافقت با قوانین و بستن مودال
        function agreeToTerms() {
            document.getElementById('terms').checked = true;
            closeTermsModal();
            
            // مخفی کردن خطا در صورت وجود
            document.getElementById('terms-error').style.display = 'none';
        }
        
        // بستن مودال با کلیک خارج از آن
        document.getElementById('termsModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeTermsModal();
            }
        });
        
        // بستن مودال با کلید ESC
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeTermsModal();
            }
        });
        function validateStep1() {
            const errorElement = document.getElementById('step1-error');
            
            if (selectedOptions.question_1.length === 0) {
                errorElement.textContent = 'لطفاً حداقل یک گزینه را انتخاب کنید';
                errorElement.style.display = 'block';
                return;
            }
            
            errorElement.style.display = 'none';
            nextStep();
        }
// مدیریت مودال
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('terms-txt');
    const closeBtn = modal.querySelector('.close');
    const closeBtn2 = modal.querySelector('.btn_1');
    
    // باز کردن مودال هنگام کلیک روی لینک قوانین
    document.querySelector('a[data-target="#terms-txt"]').addEventListener('click', function(e) {
        e.preventDefault();
        modal.style.display = 'block';
    });
    
    // بستن مودال
    closeBtn.addEventListener('click', function() {
        modal.style.display = 'none';
    });
    
    closeBtn2.addEventListener('click', function() {
        modal.style.display = 'none';
    });
    
    // بستن مودال با کلیک خارج از آن
    window.addEventListener('click', function(e) {
        if (e.target === modal) {
            modal.style.display = 'none';
        }
    });
});
        function validateStep2() {
            const genderSelect = document.getElementById('gender');
            const errorElement = document.getElementById('gender-error');
            
            if (!genderSelect.value) {
                errorElement.textContent = 'لطفاً جنسیت خود را انتخاب کنید';
                errorElement.style.display = 'block';
                return;
            }
            
            errorElement.style.display = 'none';
            nextStep();
        }

        function validateStep3() {
            // Step 3 doesn't need validation as it always has a value
            nextStep();
        }
// توابع جدید برای ذخیره داده‌های مراحل قبل
function saveStepData() {
    // ذخیره جنسیت
    document.getElementById('hiddenGender').value = document.getElementById('gender').value;
    
    // ذخیره سن
    document.getElementById('hiddenAge').value = document.getElementById('ageRange').value;
    
    // ذخیره سبک بازی
    document.getElementById('hiddenGameStyle').value = selectedOptions.question_1.join(', ');
}

        // تغییر نام تابع از validateStep4 به validateAndSubmit
        function validateAndSubmit() {
            let isValid = true;
            
            // Validate game username
            const gameUsername = document.getElementById('gameUsername').value.trim();
            const gameUsernameError = document.getElementById('gameUsername-error');
            const usernameRegex = /^[a-zA-Zآ-ی0-9]{4,20}$/;
            
            if (!gameUsername) {
                gameUsernameError.textContent = 'لطفاً نام کاربری در بازی را وارد کنید';
                gameUsernameError.style.display = 'block';
                isValid = false;
            } else if (!usernameRegex.test(gameUsername)) {
                gameUsernameError.textContent = 'نام کاربری باید بین ۴ تا ۲۰ کاراکتر و فقط شامل حروف و اعداد باشد';
                gameUsernameError.style.display = 'block';
                isValid = false;
            } else {
                gameUsernameError.style.display = 'none';
            }
            
            // Validate first name
            const firstname = document.getElementById('firstname').value.trim();
            const firstnameError = document.getElementById('firstname-error');
            
            if (!firstname) {
                firstnameError.textContent = 'لطفاً نام خود را وارد کنید';
                firstnameError.style.display = 'block';
                isValid = false;
            } else {
                firstnameError.style.display = 'none';
            }
            
            // Validate last name
            const lastname = document.getElementById('lastname').value.trim();
            const lastnameError = document.getElementById('lastname-error');
            
            if (!lastname) {
                lastnameError.textContent = 'لطفاً نام خانوادگی خود را وارد کنید';
                lastnameError.style.display = 'block';
                isValid = false;
            } else {
                lastnameError.style.display = 'none';
            }
            
            // Validate phone number
            const phone = document.getElementById('phone').value.trim();
            const phoneError = document.getElementById('phone-error');
            const phoneRegex = /^09[0-9]{9}$/;
            
            if (!phone) {
                phoneError.textContent = 'لطفاً شماره موبایل خود را وارد کنید';
                phoneError.style.display = 'block';
                isValid = false;
            } else if (!phoneRegex.test(phone)) {
                phoneError.textContent = 'شماره موبایل باید با 09 شروع شده و 11 رقمی باشد';
                phoneError.style.display = 'block';
                isValid = false;
            } else {
                phoneError.style.display = 'none';
            }
            
            // Validate password
            const password = document.getElementById('password').value;
            const passwordError = document.getElementById('password-error');
            
            if (!password) {
                passwordError.textContent = 'لطفاً رمز عبور خود را وارد کنید';
                passwordError.style.display = 'block';
                isValid = false;
            } else if (password.length < 5) {
                passwordError.textContent = 'رمز عبور باید حداقل 5 کاراکتر باشد';
                passwordError.style.display = 'block';
                isValid = false;
            } else {
                passwordError.style.display = 'none';
            }
            
            // Validate terms
            const terms = document.getElementById('terms').checked;
            const termsError = document.getElementById('terms-error');
            
            if (!terms) {
                termsError.textContent = 'لطفاً با قوانین و مقررات موافقت کنید';
                termsError.style.display = 'block';
                isValid = false;
            } else {
                termsError.style.display = 'none';
            }
            
            if (isValid) {
                saveStepData(); // ذخیره داده‌های مراحل قبل
                document.getElementById('mainForm').submit(); // ارسال فرم
            }
            
            return false; // جلوگیری از ارسال پیش‌فرض فرم
        }

// تغییر در تابع nextStep برای مرحله 4
function nextStep() {
    if (currentStep < totalSteps) {
        if (currentStep === 3) { // قبل از رفتن به مرحله 4 داده‌ها را ذخیره کن
            saveStepData();
        }
        
        document.getElementById('step' + currentStep).style.display = 'none';
        currentStep++;
        document.getElementById('step' + currentStep).style.display = 'block';
        updateProgressBar();
        updateStepIndicator();
    }
}

        function prevStep() {
            if (currentStep > 1) {
                document.getElementById('step' + currentStep).style.display = 'none';
                currentStep--;
                document.getElementById('step' + currentStep).style.display = 'block';
                updateProgressBar();
                updateStepIndicator();
            }
        }

        function updateProgressBar() {
            const progressPercentage = (currentStep / totalSteps) * 100;
            document.querySelector('.progress').style.width = progressPercentage + '%';
        }

        function updateStepIndicator() {
            const steps = document.querySelectorAll('.step');
            steps.forEach((step, index) => {
                if (index + 1 < currentStep) {
                    step.classList.add('step-complete');
                    step.classList.remove('active');
                } else if (index + 1 === currentStep) {
                    step.classList.add('active');
                    step.classList.remove('step-complete');
                } else {
                    step.classList.remove('active', 'step-complete');
                }
            });
        }

        // Initialize the form
        document.addEventListener('DOMContentLoaded', function() {
            updateProgressBar();
            updateStepIndicator();
            updateAgeValue(18); // Set initial value for age slider
        });

        // Add input validation for phone number
        document.getElementById('phone').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9]/g, '');
        });
    </script>

    <!-- Bootstrap & jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>