<?php
require_once 'config.php';
require_once 'includes/header.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

$type = $_GET['type'] ?? '';
$type_names = [
    'iranian' => 'زائران ایرانی',
    'resident' => 'زائران اتباع مقیم ایران',
    'breakfast' => 'ثبت نام صبحانه',
    'foreigner' => 'زائران غیرایرانی'
];

if (!array_key_exists($type, $type_names)) {
    redirect('dashboard.php');
}
?>

<div class="main-content">
    <div class="reservation-section">
        <h2>رزرو برای <?php echo $type_names[$type]; ?></h2>
        
        <div class="reservation-form">
            <form action="payment.php" method="POST">
                <input type="hidden" name="type" value="<?php echo $type; ?>">
                
                <div class="form-group">
                    <label for="name">نام و نام خانوادگی</label>
                    <input type="text" id="name" name="name" required>
                </div>
                
                <div class="form-group">
                    <label for="national_id">کد ملی</label>
                    <input type="text" id="national_id" name="national_id" required>
                </div>
                
                <div class="form-group">
                    <label for="date">تاریخ</label>
                    <input type="date" id="date" name="date" required>
                </div>
                
                <div class="form-group">
                    <label for="meal_type">نوع غذا</label>
                    <select id="meal_type" name="meal_type" required>
                        <option value="ناهار">ناهار</option>
                        <option value="شام">شام</option>
                        <option value="صبحانه">صبحانه</option>
                    </select>
                </div>
                
                <div class="price-section">
                    <p>هزینه رزرو: <span class="price">۴۵,۰۰۰ تومان</span></p>
                </div>
                
                <button type="submit" class="btn-primary">پرداخت و رزرو</button>
            </form>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>