<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $mobile = $_POST['mobile'];
    $captcha = $_POST['captcha'];
    
    // بررسی کپچا
    if ($captcha != $_SESSION['captcha_code']) {
        $_SESSION['error'] = "کد امنیتی نادرست است";
        redirect('index.php');
    }
    
    // بررسی شماره موبایل
    if (preg_match('/^09[0-9]{9}$/', $mobile)) {
        // بررسی وجود کاربر در دیتابیس
        $stmt = $pdo->prepare("SELECT * FROM users WHERE mobile = ?");
        $stmt->execute([$mobile]);
        $user = $stmt->fetch();
        
        if (!$user) {
            // ایجاد کاربر جدید
            $stmt = $pdo->prepare("INSERT INTO users (mobile, created_at) VALUES (?, NOW())");
            $stmt->execute([$mobile]);
            $user_id = $pdo->lastInsertId();
        } else {
            $user_id = $user['id'];
        }
        
        // ثبت اطلاعات در session
        $_SESSION['user_id'] = $user_id;
        $_SESSION['mobile'] = $mobile;
        
        redirect('dashboard.php');
    } else {
        $_SESSION['error'] = "شماره موبایل معتبر نیست";
        redirect('index.php');
    }
} else {
    redirect('index.php');
}
?>