<?php
require_once 'config.php';

if (!isLoggedIn()) {
    redirect('index.php');
}

// دریافت اطلاعات کاربر
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();
?>

<?php require_once 'includes/header.php'; ?>

<div class="welcome-section">
    <div class="section-header">
        <i class="icon"></i>
        <h2>مهمان سرا</h2>
    </div>
    <div class="message-box golden-box">
        <div class="message-icon"></div>
        <div class="message-content">
            <p class="greeting">زائر گرامی</p>
            <p class="message-text">امکان پیش ثبت نام تنها بین ساعت 7 صبح تا 8 شب امکان پذیر است.</p>
        </div>
    </div>
</div>

<div class="options-section">
    <div class="section-header">
        <i class="icon">️</i>
        <h3>گزینه‌های رزرو</h3>
    </div>
    
    <div class="options-grid">
        <div class="option-card iranian-card">
            <div class="card-icon"></div>
            <h4>زائران ایرانی</h4>
            <p>رزرو غذای زائران ایرانی</p>
            <a href="reservation.php?type=iranian" class="btn-primary">انتخاب و رزرو</a>
        </div>
        
        <div class="option-card resident-card">
            <div class="card-icon"></div>
            <h4>زائران اتباع مقیم ایران</h4>
            <p>رزرو برای اتباع خارجی مقیم</p>
            <a href="reservation.php?type=resident" class="btn-primary">انتخاب و رزرو</a>
        </div>
        
        <div class="option-card breakfast-card">
            <div class="card-icon"></div>
            <h4>ثبت نام صبحانه</h4>
            <p>رزرو وعده صبحانه</p>
            <a href="reservation.php?type=breakfast" class="btn-primary">انتخاب و رزرو</a>
        </div>
        
        <div class="option-card foreigner-card">
            <div class="card-icon"></div>
            <h4>زائران غیرایرانی</h4>
            <p>رزرو برای زائران خارجی</p>
            <a href="reservation.php?type=foreigner" class="btn-primary">انتخاب و رزرو</a>
        </div>
    </div>
</div>

<div class="quick-actions">
    <a href="history.php" class="btn-secondary">
        <i class="action-icon">📋</i>
        مشاهده سوابق رزرو
    </a>
</div>

<?php require_once 'includes/footer.php'; ?>